% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_cassette.R
\name{insert_cassette}
\alias{insert_cassette}
\title{Insert a cassette to record HTTP requests}
\usage{
insert_cassette(name, record = "once", match_requests_on = c("method",
  "uri"), update_content_length_header = FALSE,
  allow_playback_repeats = FALSE, serialize_with = "yaml",
  persist_with = "FileSystem", preserve_exact_body_bytes = FALSE,
  ignore_cassettes = FALSE, re_record_interval = NULL,
  clean_outdated_http_interactions = FALSE)
}
\arguments{
\item{name}{The name of the cassette. vcr will sanitize this to ensure it
is a valid file name.}

\item{record}{The record mode. Default: "once". In the future we'll support
"once", "all", "none", "new_episodes". See \link{recording} for more information}

\item{match_requests_on}{List of request matchers
to use to determine what recorded HTTP interaction to replay. Defaults to
\code{["method", "uri"]}. The built-in matchers are "method", "uri", "host",
"path", "headers" and "body"}

\item{update_content_length_header}{(logical) Whether or
not to overwrite the \code{Content-Length} header of the responses to
match the length of the response body. Default: \code{FALSE}}

\item{allow_playback_repeats}{(logical) Whether or not to
allow a single HTTP interaction to be played back multiple times.
Default: \code{FALSE}.}

\item{serialize_with}{(character) Which serializer to use.
Valid values are "yaml" (default), the only one supported for now.}

\item{persist_with}{(character) Which cassette persister to
use. Default: "file_system". You can also register and use a
custom persister.}

\item{preserve_exact_body_bytes}{(logical) Whether or not
to base64 encode the bytes of the requests and responses for
this cassette when serializing it. See also \code{preserve_exact_body_bytes}
in \code{\link[=vcr_configure]{vcr_configure()}}. Default: \code{FALSE}}

\item{ignore_cassettes}{(logical) turn \pkg{vcr} off and ignore cassette
insertions (so that no error is raised). Default: \code{FALSE}}

\item{re_record_interval}{(integer) How frequently (in seconds) the
cassette should be re-recorded. default: \code{NULL} (not re-recorded)}

\item{clean_outdated_http_interactions}{(logical) Should outdated
interactions be recorded back to file? default: \code{FALSE}}
}
\value{
an object of class \code{Cassette}
}
\description{
Insert a cassette to record HTTP requests
}
\examples{
\dontrun{
library(vcr)
library(crul)
vcr_configure(dir = tempdir())
webmockr::webmockr_allow_net_connect()

(x <- insert_cassette(name = "leo5"))
current_cassette()
x$new_recorded_interactions
cli <- crul::HttpClient$new(url = "https://httpbin.org")
cli$get("get")
x$new_recorded_interactions
# very important when using inject_cassette: eject when done
x$eject() # same as eject_cassette("leo5")

# cleanup
unlink(file.path(tempdir(), "leo5.yml"))
}
}
\seealso{
\code{\link[=use_cassette]{use_cassette()}}, \code{\link[=eject_cassette]{eject_cassette()}}
}
