% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_keys.R
\name{check_keys}
\alias{check_keys}
\title{Check that INFO and FORMAT keys are unique}
\usage{
check_keys(x)
}
\arguments{
\item{x}{an oblect of class vcfR}
}
\description{
The INFO and FORMAT columns contain information in key-value pairs.
If for some reason a key is not unique it will create issues in retrieving this information.
This function checks the keys defined in the meta section to make sure they are unique.
Note that it does not actually check the INFO and FORMAT columns, just their definitions in the meta section.
This is because each variant can have different information in their INFO and META cells.
Checking these on large files will tehrefore come with a performance cost.
}
\examples{
data(vcfR_test)
check_keys(vcfR_test)
queryMETA(vcfR_test)
queryMETA(vcfR_test, element = 'DP')
# Note that DP occurs as unique in INFO and FORMAT but they may be different.


}
\seealso{
queryMETA()
}
