% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{create_script}
\alias{create_script}
\alias{create_script,DatabaseDef,ANY-method}
\alias{create_script,VariableDef,ANY-method}
\alias{create_script,VariableDef,ScriptTemplate-method}
\alias{create_script,VariableDef,character-method}
\alias{create_script,data.frame,ANY-method}
\title{Create a script}
\usage{
create_script(var_desc, template, rawdata_name = "raw_data",
  cleandata_name = "clean_data", header = TRUE, footer = TRUE, ...)

\S4method{create_script}{VariableDef,ScriptTemplate}(var_desc, template,
  rawdata_name = "raw_data", cleandata_name = "clean_data",
  header = FALSE, footer = FALSE, columns_names = var_desc$rname)

\S4method{create_script}{VariableDef,character}(var_desc, template,
  rawdata_name = "raw_data", cleandata_name = "clean_data")

\S4method{create_script}{VariableDef,ANY}(var_desc, rawdata_name = "raw_data",
  cleandata_name = "clean_data", header = FALSE, footer = FALSE)

\S4method{create_script}{DatabaseDef,ANY}(var_desc, template,
  rawdata_name = "raw_data", cleandata_name = "clean_data", header = TRUE,
  footer = TRUE)

\S4method{create_script}{data.frame,ANY}(var_desc, template,
  rawdata_name = "raw_data", cleandata_name = "clean_data", header = TRUE,
  footer = TRUE)
}
\arguments{
\item{var_desc}{An object which describes the variable. Could be a single \code{\link[=VariableDef-class]{VariableDef}}, a whole \code{\link[=DatabaseDef-class]{DatabaseDef}} or a simple \code{\link[=data.frame]{data.frame}}. In this last case, \code{\link[=import_vardef]{import_vardef}} function will be called to transform it to a \code{\link[=DatabaseDef-class]{DatabaseDef}}.}

\item{template}{Optional. An object which describes the template. Either a \code{\link[=ScriptTemplate-class]{ScriptTemplate}} object or a path to the template file. In this last case,  \code{\link[=import_template]{import_template}} function will be called to transform this filepath to a \code{\link[=ScriptTemplate-class]{ScriptTemplate}}. If missing, the default template is used.}

\item{rawdata_name}{Name used to replace rep_rawdata in the template}

\item{cleandata_name}{Name used to replace rep_cleandata in the template}

\item{header}{If \code{TRUE} produce the header bloc}

\item{footer}{If \code{TRUE} produce the footer bloc}

\item{columns_names}{rnames of the columns}

\item{...}{others arguments for specifics methods}
}
\value{
A \code{\link[=ScriptOutput-class]{ScriptOutput}} object. This object could be written in a file with the \code{\link[=write_file]{write_file}} function.
}
\description{
Create a script according to the \link[=variable_definition_table]{definition of the variables} and a \link{template} .
}
\details{
\code{create_script} is the central function of the \code{vartors} package. It will collate the two input objects created by the user (a \code{\link[=VariableDef-class]{VariableDef}} object or \code{\link[=DatabaseDef-class]{DatabaseDef}} object and a \code{\link[=ScriptTemplate-class]{ScriptTemplate}} object) and will produce the final product : the script skeleton represented by an \code{\link[=ScriptOutput-class]{ScriptOutput}} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{var_desc = VariableDef,template = ScriptTemplate}: 

\item \code{var_desc = VariableDef,template = character}: 

\item \code{var_desc = VariableDef,template = ANY}: 

\item \code{var_desc = DatabaseDef,template = ANY}: 

\item \code{var_desc = data.frame,template = ANY}: 
}}
\examples{
# Import a data.frame containing the description of the variables
# Show the description of the variable
sample_descvar

# Create the script skeleton simply with create_script()
script_skeleton <- create_script(sample_descvar)
# watch the result
script_skeleton
}
\author{
Joris Muller
}
\seealso{
\code{\link{import_template}}, \code{\link{import_vardef}} and the \link[=vartors]{general documentation of vartors}.
}
\keyword{main}

