% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{date.stamp.file.name}
\alias{date.stamp.file.name}
\alias{datestamp.file.name}
\alias{datestamp.filename}
\title{date.stamp.file.name}
\usage{
date.stamp.file.name(file.name, date = Sys.Date(), separator = "_")
}
\arguments{
\item{file.name}{File name to be date-stamped}

\item{date}{Date to be added. Defaults to current date.}

\item{separator}{String that should separate the date from the file name. Defaults to a single underscore.}
}
\value{
String giving the datestamped file name
}
\description{
Prefix file name with a date-stamp.
}
\examples{
date.stamp.file.name('plot.png');
date.stamp.file.name('yesterdays_plot.png', date = Sys.Date() - 1);

}
