% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{valueEQ5D3LIndscores}
\alias{valueEQ5D3LIndscores}
\title{Function to value EQ-5D-3L scores for various countries}
\usage{
valueEQ5D3LIndscores(country, method, this.response, this.response2 = NA,
  this.response3 = NA, this.response4 = NA, this.response5 = NA)
}
\arguments{
\item{country}{a country name from the list Belgium,Brazil,Canada,Chile,Denmark,Europe,Finland,France,Germany,Italy,Japan,Korea,Netherlands,NewZealand,Poland,Portugal,Slovenia,Spain,Taiwan,Thailand,UK,USA,and Zimbabwe}

\item{method}{method name either TTO or VAS}

\item{this.response}{a must input,response for EQ-5D-5L mobility  or the 5 digit response, or the vector of responses, e.g. 11111, c(1,1,1,1,1) or 1}

\item{this.response2}{response for EQ-5D-3L self care, or NA if the responses are given as this.response}

\item{this.response3}{response for EQ-5D-3L usual activities,or NA if the responses are given as this.response}

\item{this.response4}{response for EQ-5D-3L pain/discomfort, or NA if the responses are given as this.response}

\item{this.response5}{response for EQ-5D-3L anxiety/depression, or NA if the responses are given as this.response}
}
\value{
index value based if success, negative values for failure
}
\description{
Function to value EQ-5D-3L scores for various countries
}
\examples{
valueEQ5D3LIndscores("UK","TTO",23131)
valueEQ5D3LIndscores("Spain","TTO",2,3,1,3,1)
valueEQ5D3LIndscores("Denmark","VAS",c(1,2,3,1,3))
}
