% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{plot,validator-method}
\alias{plot,validator-method}
\title{Plot a validator object}
\usage{
\S4method{plot}{validator}(
  x,
  y,
  use_blocks = TRUE,
  col = c("#b2df8a", "#a6cee3"),
  cex = 1,
  show_legend = TRUE,
  ...
)
}
\arguments{
\item{x}{validator object with rules}

\item{y}{not used}

\item{use_blocks}{\code{logical} if \code{TRUE} the matrix is sorted
according to the connected sub sets of variables (aka blocks).}

\item{col}{\code{character} with color codes for plotting variables.}

\item{cex}{size of the variables plotted.}

\item{show_legend}{should a legend explaining the colors be drawn?}

\item{...}{passed to image}
}
\value{
(invisible) the matrix
}
\description{
The matrix of variables x rules is plotted, in which rules that are
recognized as linear (in)equations are differently colored. 
The augmented matrix is returned, but can also be calculated using
\code{variables(x, as="matrix")}.
}
\examples{
rules <- validator( r1 = staff.costs < total.costs
                  , r2 = turnover + other.rev == total.rev
                  , r3 = other.rev > 0
                  , r4 = total.rev > 0
                  , r5 = nace \%in\% c("A", "B")
                  )
plot(rules, cex=0.8, show_legend=TRUE)

data(retailers)
cf <- confront(retailers, rules)
plot(cf, main="Retailers check")
}
\seealso{
\code{\link{variables}}

Other validator-methods: 
\code{\link{+,validator,validator-method}},
\code{\link{validator}}

Other expressionset-methods: 
\code{\link{as.data.frame,expressionset-method}},
\code{\link{as.data.frame}()},
\code{\link{created}()},
\code{\link{description}()},
\code{\link{label}()},
\code{\link{meta}()},
\code{\link{names<-,rule,character-method}},
\code{\link{origin}()},
\code{\link{summary}()},
\code{\link{variables}()},
\code{\link{voptions}()}
}
\concept{expressionset-methods}
\concept{validator-methods}
