% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{scalar-checkers}
\alias{scalar-checkers}
\title{Scalar checkers}
\arguments{
\item{\dots}{Check items, i.e., formulae that are one-sided or have a string
as left-hand side (see \emph{Check Formulae of Local Scope} in the
documentation page \link{firmly}). These are the expressions to check.}
}
\value{
Check formula of local scope.
}
\description{
These functions make check formulae of local scope based on the
correspondingly named scalar type predicate from \pkg{base} R. For example,
\code{vld_scalar_logical} creates check formulae (of local scope) for the
predicate \code{is.logical(.) && length(.) == 1}. The function \code{vld_singleton} is
based on the predicate \code{length(.) == 1}.

The functions \code{vld_boolean}, \code{vld_number}, \code{vld_string} are aliases for
\code{vld_scalar_logical}, \code{vld_scalar_numeric}, \code{vld_scalar_character}, resp.
(with appropriately modified error messages).
}
\details{
Each function \code{vld_*} is a function of class
\code{"check_maker"}, generated by \code{\link{localize}}.
}
\examples{
\dontrun{

f <- function(x, y) "Pass"

# Impose a check on x: ensure it's boolean (i.e., a scalar logical vector)
f_firm <- firmly(f, vld_boolean(~x))
f_firm(TRUE, 0)           # [1] "Pass"
f_firm(c(TRUE, TRUE), 0)  # Error: "Not boolean: x"

# Use a custom error message
f_firm <- firmly(f, vld_boolean("x is not TRUE/FALSE/NA" ~ x))
f_firm(c(TRUE, TRUE), 0)  # Error: "x is not TRUE/FALSE/NA"

# To impose the same check on all arguments, apply globalize
f_firmer <- firmly(f, globalize(vld_boolean))
f_firmer(TRUE, FALSE)    # [1] "Pass"
f_firmer(TRUE, 0)        # Error: "Not boolean: `y`"
f_firmer(logical(0), 0)  # Errors: "Not boolean: `x`", "Not boolean: `y`"
}
}
\alias{vld_boolean}
\alias{vld_number}
\alias{vld_scalar_atomic}
\alias{vld_scalar_character}
\alias{vld_scalar_complex}
\alias{vld_scalar_double}
\alias{vld_scalar_integer}
\alias{vld_scalar_list}
\alias{vld_scalar_logical}
\alias{vld_scalar_numeric}
\alias{vld_scalar_raw}
\alias{vld_scalar_vector}
\alias{vld_singleton}
\alias{vld_string}
\usage{
vld_boolean(...)

vld_number(...)

vld_scalar_atomic(...)

vld_scalar_character(...)

vld_scalar_complex(...)

vld_scalar_double(...)

vld_scalar_integer(...)

vld_scalar_list(...)

vld_scalar_logical(...)

vld_scalar_numeric(...)

vld_scalar_raw(...)

vld_scalar_vector(...)

vld_singleton(...)

vld_string(...)
}
\seealso{
Corresponding predicates: \code{\link[base]{is.atomic}}, \code{\link[base]{is.character}}, \code{\link[base]{is.complex}}, \code{\link[base]{is.double}}, \code{\link[base]{is.integer}}, \code{\link[base]{is.list}}, \code{\link[base]{is.logical}}, \code{\link[base]{is.numeric}}, \code{\link[base]{is.raw}}, \code{\link[base]{is.vector}}

\code{\link{globalize}} recovers the underlying check formula of global scope.

The notions of \dQuote{scope} and \dQuote{check item} are explained in the \emph{Check Formulae} section of \link{firmly}.

Other checkers: \link{type-checkers}, \link{misc-checkers}
}
