% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{multilabel_evaluate}
\alias{multilabel_evaluate}
\alias{multilabel_evaluate.mldr}
\alias{multilabel_evaluate.mlconfmat}
\title{Evaluate multi-label predictions}
\usage{
multilabel_evaluate(object, ...)

\method{multilabel_evaluate}{mldr}(object, mlresult, measures = c("all"), labels = FALSE, ...)

\method{multilabel_evaluate}{mlconfmat}(object, measures = c("all"), labels = FALSE, ...)
}
\arguments{
\item{object}{A mldr dataset or a mlconfmat confusion matrix}

\item{...}{Extra parameters to specific measures.}

\item{mlresult}{The prediction result (Optional, required only when the
mldr is used).}

\item{measures}{The measures names to be computed. Call
\code{multilabel_measures()} to see the expected measures. You can also
use \code{"bipartition"}, \code{"ranking"}, \code{"label-based"},
\code{"example-based"}, \code{"macro-based"}, \code{"micro-based"} and
\code{"label-problem"} to include a set of measures. (Default: "all").}

\item{labels}{Logical value defining if the label results should be also
returned. (Default: \code{FALSE})}
}
\value{
If labels is FALSE return a vector with the expected multi-label
 measures, otherwise, a list contained the multi-label and label measures.
}
\description{
This method is used to evaluate multi-label predictions. You can create a
confusion matrix object or use directly the test dataset and the predictions.
You can also specify which measures do you desire use.
}
\section{Methods (by class)}{
\itemize{
\item \code{mldr}: Default S3 method

\item \code{mlconfmat}: Default S3 method
}}

\examples{
\dontrun{
prediction <- predict(br(toyml), toyml)

# Compute all measures
multilabel_evaluate(toyml, prediction)
multilabel_evaluate(toyml, prediction, labels=TRUE) # Return a list

# Compute bipartition measures
multilabel_evaluate(toyml, prediction, "bipartition")

# Compute multilples measures
multilabel_evaluate(toyml, prediction, c("accuracy", "F1", "macro-based"))

# Compute the confusion matrix before the measures
cm <- multilabel_confusion_matrix(toyml, prediction)
multilabel_evaluate(cm)
multilabel_evaluate(cm, "example-based")
multilabel_evaluate(cm, c("hamming-loss", "subset-accuracy", "F1"))
}
}
\references{
Madjarov, G., Kocev, D., Gjorgjevikj, D., & Dzeroski, S. (2012). An
   extensive experimental comparison of methods for multi-label learning.
   Pattern Recognition, 45(9), 3084-3104.
 Zhang, M.-L., & Zhou, Z.-H. (2014). A Review on Multi-Label Learning
   Algorithms. IEEE Transactions on Knowledge and Data Engineering, 26(8),
   1819-1837.
 Gibaja, E., & Ventura, S. (2015). A Tutorial on Multilabel Learning.
   ACM Comput. Surv., 47(3), 52:1-2:38.
}
\seealso{
Other evaluation: 
\code{\link{cv}()},
\code{\link{multilabel_confusion_matrix}()},
\code{\link{multilabel_measures}()}
}
\concept{evaluation}
