% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PFD.R
\name{PFD}
\alias{PFD}
\alias{print.prime.factor.decomposition}
\title{Prime Factor Decomposition (PFD)}
\usage{
PFD(x)

\method{print}{prime.factor.decomposition}(x, quote = FALSE, ...)
}
\arguments{
\item{x}{An input vector/matrix/array (can be a vector of integers/bigz or PFDs)}

\item{quote}{logical, indicating whether or not strings should be printed with surrounding quotes.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If the input is integer/bigz then the output is the PFD; if the input is PFD then the output is integer/bigz
}
\description{
\code{PFD} converts a positive integer to its prime-factor decomposition or *vice versa*
}
\details{
This function converts a vector of integers to a corresponding character vector giving the prime-factor decomposition in a condensed form.
The input can be a vector of integers or a 'bigz' vector containing large integers.  In either case the function returns the corresponding
vector of the prime-factor decomposition (PFD) values, written in a condensed character form.  The function also converts back from the PFD
form to an integer/bigz vector.

This function depends on the gmp package.
}
\examples{
PFD(1:10)
stopifnot(all.equal(1:100, PFD(PFD(1:100))))
}
