% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips.R
\name{fips}
\alias{fips}
\title{Retrieve FIPS code for either a US state or county}
\usage{
fips(state, county = "")
}
\arguments{
\item{state}{The state for which to obtain a FIPS code.
Can be entered as either a state abbrevation or full name (case-insensitive).}

\item{county}{The county for which to obtain a FIPS code.
Can be entered with or without "county" (case-insensitive).}
}
\value{
The FIPS code of given \code{state} or \code{county}.
}
\description{
Each US state and county has a unique FIPS
  (Federal Information Processing Standards) code. Use
  this function to obtain the FIPS code for a state or
  county.
}
\details{
State and county FIPS (Federal Information Processing Standards) are
  two and five digit codes, respectively. They uniquely identify all states and
  counties within the United States. The first two digits of the five digit county
  codes correspond to the state that the county belongs to. FIPS codes also exist
  for US territories and minor outlying islands, though this package only provides
  information for the 50 US states (and their associated counties and
  census designated areas).
}
\note{
A \code{state} must be included when searching for \code{county},
 otherwise multiple results may be returned for duplicate county names.
}
\examples{
fips("NJ")
fips("California")
fips("CA", county = "orange")
fips(state = "AL", county = "autauga")
fips(state = "Alabama", county = "Autauga County")
}
