% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{use_git_config}
\alias{use_git_config}
\title{Configure Git}
\usage{
use_git_config(scope = c("user", "project"), ...)
}
\arguments{
\item{scope}{Edit globally for the current \strong{user}, or locally for the
current \strong{project}}

\item{...}{Additional options to write or delete from the
configuration.}
}
\value{
A list with components \code{user.name} and \code{user.email}.
}
\description{
Sets Git options, for either the user or the project ("global" or "local", in
Git terminology). The mandate is currently very narrow: to manage the user
name and email. The \code{scope} argument is consulted when writing. When reading,
\code{use_git_config()} ignores \code{scope} and simply reports the options in effect,
where local config overrides global, if present. Use \code{\link[git2r:config]{git2r::config()}}
directly or the command line for general Git configuration.
}
\examples{
\dontrun{
## see if user name and email are currently configured
use_git_config()

## set the user's global user.name and user.email
use_git_config(user.name = "Jane", user.email = "jane@example.org")

## set the user.name and user.email locally, i.e. for current repo/project
use_git_config(
  scope = "project",
  user.name = "Jane",
  user.email = "jane@example.org"
)
}
}
\seealso{
Other git helpers: \code{\link{use_git_hook}},
  \code{\link{use_git_ignore}}, \code{\link{use_git}}
}
\concept{git helpers}
