% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid.R
\name{digitizeProfiles}
\alias{digitizeProfiles}
\title{Digitization}
\usage{
digitizeProfiles(sp, delta = 0.01, win = NULL)
}
\arguments{
\item{sp}{list of section profiles, see \code{\link{intersectSystem}}}

\item{delta}{lattice constant for discretization of section profiles}

\item{win}{list of length two, the intersection window, default \code{NULL}}
}
\value{
binary (integer) matrix as an image
}
\description{
Digitize 2D section profiles
}
\details{
A list of section profiles, e.g. discs, ellipses or segments from intersected spherocylinders, is digitized according
to a given resolution according to the lattice constant \code{delta} such that the result is an integer matrix 
which can be interpretated as a binary image. An intersection window can be either provided by the user w.r.t. \eqn{[l,u]^2}
where \code{l,u}	are lower, respectively, upper bounds of corresponding to a simulation box, or, it is taken from the section
profiles \code{sp} which stores the intersection window as an attribute.
}
\examples{
 # simulation box
 box <- list("xrange"=c(0,5),"yrange"=c(0,5),"zrange"=c(0,5))
 # (exact) bivariate size-shape (isotropic) orientation distribution (spheroids)
 theta <- list("size"=list("mx"=-2.5,"my"=0.5, "sdx"=0.35,"sdy"=0.25,"rho"=0.15),
               "orientation"=list("kappa"=1))

 # return only 3D system
 S <- simPoissonSystem(theta,lam=100,size="rbinorm",box=box,type="prolate",
       intersect="original",n=c(0,1,0),mu=c(0,0,1),perfect=TRUE,pl=1)

 # vertical intersection w.r.t. 'mu' (z axis, see above)
 sp <- intersectSystem(S, 2.5)

 # show intersecting window
 win <- attr(sp,"win")

 # digitize (could also pass some 'win' as an argument) 	
 W <- digitizeProfiles(sp, delta=0.01, win = NULL)  
 image(1:nrow(W),1:ncol(W),W,col=gray(1:0))

}
\author{
M. Baaske
}
