% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_as_numeric}
\alias{umx_as_numeric}
\title{umx_as_numeric}
\usage{
umx_as_numeric(df, which = NULL, force = FALSE)
}
\arguments{
\item{df}{A [data.frame()] to convert}

\item{which}{which columns to convert (default (null) selects all)}

\item{force}{Whether to force conversion to numeric for non-numeric columns (defaults to FALSE)}
}
\value{
- data.frame
}
\description{
Convert each column of a dataframe to numeric
}
\examples{
df = mtcars
# make mpg into string, and cyl into a factor
df$mpg = as.character(df$mpg)
df$cyl = factor(df$cyl)

df = umx_as_numeric(df); str(df) # mpg not touched
df = umx_as_numeric(df, force=TRUE); str(df) # mpg coerced back to numeric
\dontrun{
# coercing a real string will cause NAs
df$mpg = c(letters[1:16]); str(df) # replace mpg with letters.
df = umx_as_numeric(df, force=TRUE); str(df)
}
}
\references{
- <https://github.com/tbates/umx>
}
\seealso{
Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_read_prolific_demog}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
