% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxPower.R
\name{power.ACE.test}
\alias{power.ACE.test}
\title{Test the power of an ACE model to detect paths of interest.}
\usage{
power.ACE.test(
  AA = 0.5,
  CC = 0,
  EE = NULL,
  update = c("a", "c", "a_after_dropping_c"),
  value = 0,
  n = NULL,
  MZ_DZ_ratio = 1,
  sig.level = 0.05,
  power = 0.8,
  method = c("ncp", "empirical"),
  search = FALSE,
  tryHard = c("yes", "no", "ordinal", "search"),
  digits = 2,
  optimizer = NULL,
  nSim = 4000
)
}
\arguments{
\item{AA}{Additive genetic variance (Default .5)}

\item{CC}{Shared environment variance (Default 0)}

\item{EE}{Unique environment variance. Leave NULL (default) to compute an amount summing to 1}

\item{update}{Component to drop (Default "a", i.e., drop a)}

\item{value}{Value to set dropped path to (Default 0)}

\item{n}{If provided, solve at the given n (Default NULL)}

\item{MZ_DZ_ratio}{MZ pairs per DZ pair (Default 1 = equal numbers.)}

\item{sig.level}{alpha (p-value) Default = 0.05}

\item{power}{Default = .8 (80 percent power, equal to 1 - Type II rate)}

\item{method}{How to estimate power: Default =  use non-centrality parameter ("ncp"). Alternative is "empirical"}

\item{search}{Whether to return a search across power or just a point estimate (Default FALSE = point)}

\item{tryHard}{Whether to tryHard to find a solution (default = "yes", alternatives are "no"...)}

\item{digits}{Rounding for reporting parameters (default 2)}

\item{optimizer}{If set, will switch the optimizer.}

\item{nSim}{Total number of pairs to simulate in the models (default = 4000)}
}
\value{
\code{\link[OpenMx:mxPower]{OpenMx::mxPower()}} object
}
\description{
\code{power.ACE.test} simulates a univariate ACE model (with nMZpairs= 2000 and MZ_DZ_ratio*nMZpairs DZ twins. It
computes power to detect dropping one or more paths specified in \verb{drop=}.
The interface and functionality of this service are experimental and subject to change.
}
\details{
Statistical power is the proportion of studies that, over the long run, one should expect to yield a statistically
significant result given certain study characteristics such as sample size (N), the expected effect size (\eqn{\beta}),
and the criterion for statistical significance (\eqn{\alpha}).

A typical target for power is 80\%. Much as the accepted critical p-value is .05, this has emerged as a trade off, in this case
of resources required for more powerful studies against the cost of missing a true effect.  People interested in truth
discourage running studies with low power: A study with 20 percent power will fail to detect real effects 80\% of the time.
But even with zero power, the Type-I error rate remains a nominal 5\% (and with any researcher degrees of freedom, perhaps much more than that).
Low powered research, then, fails to detect true effects, and generates support for random false theories about as often.
This sounds silly, but empirical rates are often as low as 20\% (Button, et al., 2013).

Illustration of  \eqn{\alpha}, \eqn{\beta}, and power (1-\eqn{\beta}):

\if{html}{\figure{power.png}{options: width="50\%" alt="Figure: power.png"}}
\if{latex}{\figure{power.pdf}{options: width=7cm}}
}
\examples{

# ===============================================
# = Power to detect a^2=.5 with equal MZ and DZ =
# ===============================================
power.ACE.test(AA = .5, CC = 0, update = "a") 
# Suggests n = 84 MZ and 94 DZ pairs.

\dontrun{
# ================================
# = Show power across range of N =
# ================================
power.ACE.test(AA= .5, CC= 0, update = "a", search = TRUE)

# Salutary note: You need well fitting models with correct betas in the data
# for power to be valid.
# tryHard helps ensure this, as does the default nSim= 4000 pair data.
# Power is important to get right, so I recommend using tryHard = "yes" (the default)
power.ACE.test(AA= .5, CC= 0, update = "a")

# =====================
# = Power to detect C =
# =====================

# 102 of each of MZ and DZ pairs for 80\% power.
power.ACE.test(AA= .5, CC= .3, update = "c")

# ==========================================
# = Set 'a' to a fixed, but non-zero value =
# ==========================================

power.ACE.test(update= "a", value= sqrt(.2), AA= .5, CC= 0)

# ========================================
# = Drop More than one parameter (A & C) =
# ========================================
# E vs AE: the hypothesis that twins show no familial similarity.
power.ACE.test(update = "a_after_dropping_c", AA= .5, CC= .3)

# ===================================================
# = More power to detect A > 0 when more C present  =
# ===================================================

power.ACE.test(update = "a", AA= .5, CC= .0)
power.ACE.test(update = "a", AA= .5, CC= .3)

# ====================================================
# = More power to detect C > 0 when more A present?  =
# ====================================================

power.ACE.test(update = "c", AA= .0, CC= .5)
power.ACE.test(update = "c", AA= .3, CC= .5)


# ===============================================
# = Power with more DZs than MZs and vice versa =
# ===============================================

# Power about the same: total pairs with 2 MZs per DZ = 692, vs. 707
power.ACE.test(MZ_DZ_ratio= 2/1, update= "a", AA= .3, CC= 0, method="ncp", tryHard="yes")
power.ACE.test(MZ_DZ_ratio= 1/2, update= "a", AA= .3, CC= 0, method="ncp", tryHard="yes")


# =====================================
# = Compare ncp and empirical methods =
# =====================================
# Compare to empirical mode: suggests 83.6 MZ and 83.6 DZ pairs

power.ACE.test(update= "a", AA= .5, CC= 0, method= "empirical")
# method= "empirical": For 80\% power, you need 76 MZ and 76 DZ pairs
power.ACE.test(update= "a", AA= .5, CC= 0, method = "ncp")
# method = "ncp": For 80\% power, you need 83.5 MZ and 83.5 DZ pairs

# ====================
# = Show off options =
# ====================
# 1. tryHard

power.ACE.test(update = "a", AA= .5, CC= 0, tryHard= "no")

# 2. toggle optimizer
power.ACE.test(update= "a", AA= .5, CC= 0, optimizer= "SLSQP")

# 3. How many twin pairs in the base simulated data?
power.ACE.test(update = "a", AA= .5, CC= 0)
power.ACE.test(update = "a", AA= .5, CC= 0, nSim= 20)

}

}
\references{
\itemize{
\item Visscher, P.M., Gordon, S., Neale, M.C. (2008). Power of the classical twin design
revisited: II detection of common environmental variance. \emph{Twin Res Hum Genet}, \strong{11}: 48-54.
\doi{10.1375/twin.11.1.48}.
\item Button, K. S., Ioannidis, J. P., Mokrysz, C., Nosek, B. A., Flint, J., Robinson, E. S., and Munafo, M. R. (2013).
Power failure: why small sample size undermines the reliability of neuroscience.
\emph{Nature Reviews Neuroscience}, \strong{14}, 365-376. \doi{10.1038/nrn3475}
}
}
\seealso{
\itemize{
\item \code{\link[OpenMx:mxPower]{OpenMx::mxPower()}}
}

Other Twin Modeling Functions: 
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
