% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxPlotACEcov}
\alias{umxPlotACEcov}
\alias{plot.MxModelACEcov}
\title{Make a graphical display of an ACE model with covariates.}
\usage{
umxPlotACEcov(
  x = NA,
  file = "name",
  digits = 2,
  means = FALSE,
  std = TRUE,
  strip_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{\link[=mxModel]{mxModel()}} to plot (created by umxACE in order to inherit the MxModelACE class)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{means}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Additional (optional) parameters}
}
\value{
\itemize{
\item optionally return the dot code
}
}
\description{
Make a graphical display of an ACE model with covariates.
}
\examples{
\dontrun{
require(umx)
# BMI ?twinData from Australian twins. 
# Cohort 1 Zygosity 1 == MZ females 3 == DZ females
data(twinData)

# Pick the variables. We will use base names (i.e., "bmi") and set suffix.
selDVs  = c("bmi")
selCovs = c("ht")
selVars = umx_paste_names(c(selDVs, selCovs), sep = "", suffixes= 1:2)
# Just top few pairs so example runs quickly
mzData = subset(twinData, zygosity == "MZFF", selVars)[1:100, ]
dzData = subset(twinData, zygosity == "DZFF", selVars)[1:100, ]
m1 = umxACEcov(selDVs= selDVs, selCovs= selCovs, dzData= dzData, mzData= mzData, sep= "")
plot(m1)
plot(m1, std = FALSE) # don't standardize
}
}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxACE]{umxACE()}}
}

Other Plotting functions: 
\code{\link{ggAddR}()},
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umxPlot}()},
\code{\link{umx}}
}
\concept{Plotting functions}
