% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoCbyPath.R
\name{plot.MxModelTwinMaker}
\alias{plot.MxModelTwinMaker}
\alias{umxPlotMxModelTwinMaker}
\title{Create and display a graphical path diagram for a path-based twin model.}
\usage{
\method{plot}{MxModelTwinMaker}(
  x = NA,
  std = FALSE,
  fixed = TRUE,
  means = TRUE,
  oneTwin = TRUE,
  sep = "_T",
  digits = 2,
  file = "name",
  labels = c("none", "labels", "both"),
  resid = c("circle", "line", "none"),
  strip_zero = FALSE,
  splines = TRUE,
  min = NULL,
  same = NULL,
  max = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\link[=umxTwinMaker]{umxTwinMaker()}} model from which to make a path diagram}

\item{std}{Whether to standardize the model (default = FALSE)}

\item{fixed}{Whether to show fixed paths (defaults to TRUE)}

\item{means}{Whether to show means or not (default = TRUE)}

\item{oneTwin}{(whether to plot a pair of twins, or just one (default = TRUE)}

\item{sep}{The separator for twin variables ("_T")}

\item{digits}{The number of decimal places to add to the path coefficients}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{labels}{Whether to show labels on the paths. "none", "labels", or "both" (parameter + label).}

\item{resid}{How to show residuals and variances default is "circle". Options are "line" & "none"}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = FALSE)}

\item{splines}{Whether to allow lines to curve: defaults to TRUE (nb: some models look better with FALSE)}

\item{min}{optional list of objects to group at the top of the plot. Default (NULL) chooses automatically.}

\item{same}{optional list of objects to group at the same rank in the plot. Default (NULL) chooses automatically.}

\item{max}{optional list of objects to group at the bottom of the plot. Default (NULL) chooses automatically.}

\item{...}{Optional parameters}
}
\description{
Assumes the model has a group called "MZ" inside.
}
\details{
If you use umx_set_plot_format("graphviz"), they will open in a graphviz helper app (if installed).
The commercial application \dQuote{OmniGraffle} is great for editing these images.
On unix and windows, \code{\link[=plot]{plot()}} will create a pdf and open it in your default pdf reader.
}
\examples{
\dontrun{
require(umx)
# 
# =====================
# = Make an ACE model =
# =====================
# 1. Clean data: Add separator and scale
data(twinData)
tmp = umx_make_twin_data_nice(data=twinData, sep="", zygosity="zygosity", numbering=1:2)
tmp = umx_scale_wide_twin_data(varsToScale= c("wt", "ht"), sep= "_T", data= tmp)
mzData = subset(tmp, zygosity \%in\%  c("MZFF", "MZMM"))
dzData = subset(tmp, zygosity \%in\%  c("DZFF", "DZMM"))

# 2. Define paths: You only need the paths for one person:
paths = c(
umxPath(v1m0 = c("a1", 'c1', "e1")),
umxPath(means = c("wt")),
umxPath(c("a1", 'c1', "e1"), to = "wt", values=.2)
)
m1 = umxTwinMaker("test", paths, mzData = mzData, dzData= dzData)
plot(m1, std= TRUE, means= FALSE)
plot(m1, means=FALSE, std=TRUE, strip=TRUE, splines="FALSE", max="intercept")
} # end dontrun

# =================
# = An ACEv model =
# =================
# Not complete

paths = c(
umxPath(v1m0 = c("A1", 'C1', "E1")),
umxPath(v1m0 = c("A2", 'C2', "E2")),
umxPath(v.m0 = c("l1", 'l2')),
umxPath(v.m. = c("wt", "ht")),
umxPath(c("A1", 'C1', "E1"), to = "l1", values= .2),
umxPath(c("A2", 'C2', "E2"), to = "l2", values= .2),
umxPath(c("l1", 'l2'), to = c("wt", "ht"), values= .2)
)

}
\seealso{
\itemize{
\item \code{\link[=umx_set_plot_format]{umx_set_plot_format()}}, \code{\link[=plot.MxModel]{plot.MxModel()}}, \code{\link[=umxPlotACE]{umxPlotACE()}}, \code{\link[=umxPlotCP]{umxPlotCP()}}, \code{\link[=umxPlotIP]{umxPlotIP()}}, \code{\link[=umxPlotGxE]{umxPlotGxE()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
