% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{fin_compound_interest}
\alias{fin_compound_interest}
\title{Compute the value of a principle plus annual savings, at a compound interest over a number of years}
\usage{
fin_compound_interest(
  principal = 0,
  deposits = 0,
  interest = 0.05,
  yrs = 10,
  n = 12,
  when = "beginning",
  symbol = "$"
)
}
\arguments{
\item{principal}{The initial investment at time 0.}

\item{deposits}{Optional periodic additional investment each \emph{year}.}

\item{interest}{Annual interest rate (decimal)}

\item{yrs}{Duration of the investment.}

\item{n}{Compounding per unit time (e.g. 12 for monthly, 365 for daily)}

\item{when}{Deposits made at the "beginning" (of each year) or "end"}

\item{symbol}{Currency symbol to embed in the result.}
}
\value{
\itemize{
\item Value after yrs
}
}
\description{
This function allows you to determine the final value of a principle, with optional additional
periodic savings, over a number of years at a given rate of interest.
}
\details{
None.
If an amount of $5,000 is deposited into a savings account at an annual interest rate of 5\%, compounded monthly,
with additional deposits of $100 per month (made at the end of each month). The value of the investment after 10
years can be calculated as follows...
}
\examples{
#
# Value of a principle after yrs years at 5\% return, compounding monthly.
fin_compound_interest(principal = 5000, interest = 0.05, yrs = 10)
# annual compounding
fin_compound_interest(principal = 5000, interest = 0.05, yrs = 10, n=1)
#
# Value of periodic deposit of $100/yr after 10 years at rate 7\% return.
fin_compound_interest(deposits = 100, interest = 0.07, yrs = 10, n = 12)
#
# Value of principal + deposit of $100/yr after 10 years at rate 7\% return.
fin_compound_interest(principal = 20000, deposits = 100, interest = 0.07, yrs = 10)
#
fin_compound_interest(deposits = 20e3, interest = 0.07, yrs = 10, n=1)
# manually
sum(20e3*(1.07^(10:1))) # 295672

# $10,000 invested at the end of each year for 5 years at 6\%
fin_compound_interest(deposits = 10e3, interest = 0.06, yrs = 5, n=1, when= "end")

}
\references{
\itemize{
\item \href{https://tbates.github.io}{tutorials}, \href{https://github.com/tbates/umx}{tutorials}
}
}
\seealso{
\itemize{
\item \code{\link[=fin_percent_off]{fin_percent_off()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_percent_off}()},
\code{\link{rad2deg}()}
}
\concept{Miscellaneous Functions}
