% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxExpCov}
\alias{umxExpCov}
\alias{vcov.MxModel}
\title{Get the expected vcov matrix}
\usage{
umxExpCov(object, latents = FALSE, manifests = TRUE, digits = NULL, ...)
}
\arguments{
\item{object}{an \code{\link[=mxModel]{mxModel()}} to get the covariance matrix from}

\item{latents}{Whether to select the latent variables (defaults to TRUE)}

\item{manifests}{Whether to select the manifest variables (defaults to TRUE)}

\item{digits}{precision of reporting. NULL (Default) = no rounding.}

\item{...}{extra parameters (to match \code{\link[=vcov]{vcov()}})}
}
\value{
\itemize{
\item expected covariance matrix
}
}
\description{
Extract the expected covariance matrix from an \code{\link[=mxModel]{mxModel()}}
}
\examples{
\dontrun{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)#'
vcov(m1) # supplied by OpenMx
umxExpCov(m1, digits = 3)

}
}
\references{
\itemize{
\item \url{https://openmx.ssri.psu.edu/thread/2598}
Original written by \url{https://openmx.ssri.psu.edu/users/bwiernik}
}
}
\seealso{
\itemize{
\item \code{\link[=umxRun]{umxRun()}}, \code{\link[=umxCI_boot]{umxCI_boot()}}
}

Other Reporting functions: 
\code{\link{RMSEA.MxModel}()},
\code{\link{RMSEA.summary.mxmodel}()},
\code{\link{RMSEA}()},
\code{\link{extractAIC.MxModel}()},
\code{\link{loadings.MxModel}()},
\code{\link{loadings}()},
\code{\link{residuals.MxModel}()},
\code{\link{tmx_show.MxMatrix}()},
\code{\link{tmx_show}()},
\code{\link{umxCI_boot}()},
\code{\link{umxCI}()},
\code{\link{umxConfint}()},
\code{\link{umxExpMeans}()},
\code{\link{umxFitIndices}()},
\code{\link{umxRotate}()}
}
\concept{Reporting functions}
