% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmx.R
\name{tmx_show.MxMatrix}
\alias{tmx_show.MxMatrix}
\title{Show matrices of models in a easy-to-learn-from format.}
\usage{
\method{tmx_show}{MxMatrix}(
  x,
  what = c("values", "free", "labels", "nonzero_or_free"),
  show = c("free", "fixed", "all"),
  matrices = c("S", "A", "M"),
  digits = 2,
  report = c("html", "markdown"),
  na.print = "",
  zero.print = ".",
  html_font = NULL,
  style = c("paper", "material_dark", "classic", "classic_2", "minimal", "material"),
  bootstrap_options = c("hover", "bordered", "condensed", "responsive"),
  lightable_options = "striped"
)
}
\arguments{
\item{x}{an object e.g. \code{\link[=umxRAM]{umxRAM()}} \code{\link[=umxMatrix]{umxMatrix()}} from which to show parameters.}

\item{what}{legal options are "values" (default), "free", or "labels").}

\item{show}{filter on what to show c("all", "free", "fixed").}

\item{matrices}{to show  (default is c("S", "A")). "thresholds" in beta.}

\item{digits}{precision to report. Default = round to 2 decimal places.}

\item{report}{How to report the results. "html" = open in browser.}

\item{na.print}{How to display NAs (default = "")}

\item{zero.print}{How to display 0 values (default = ".")}

\item{html_font}{Default is null. Set (e.g. "Optima") to override the style's default font.}

\item{style}{The style for the table (Defaults to "paper". Other options are "material_dark", "classic", "classic_2", "minimal", "material")}

\item{bootstrap_options}{border etc. Defaults to c("hover", "bordered", "condensed", "responsive")}

\item{lightable_options}{Default is "striped"}
}
\value{
None
}
\description{
Show matrices of models in a easy-to-learn-from format.
}
\seealso{
Other Reporting functions: 
\code{\link{RMSEA.MxModel}()},
\code{\link{RMSEA.summary.mxmodel}()},
\code{\link{RMSEA}()},
\code{\link{extractAIC.MxModel}()},
\code{\link{loadings.MxModel}()},
\code{\link{loadings}()},
\code{\link{residuals.MxModel}()},
\code{\link{tmx_show}()},
\code{\link{umxCI_boot}()},
\code{\link{umxCI}()},
\code{\link{umxConfint}()},
\code{\link{umxExpCov}()},
\code{\link{umxExpMeans}()},
\code{\link{umxFitIndices}()},
\code{\link{umxRotate}()}
}
\concept{Reporting functions}
