% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxACEv.R
\name{umxPlotACEv}
\alias{umxPlotACEv}
\alias{plot.MxModelACEv}
\title{Produce a graphical display of an ACE variance-components twin model}
\usage{
umxPlotACEv(
  x = NA,
  file = "name",
  digits = 2,
  means = FALSE,
  std = TRUE,
  strip_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{\link[=umxACEv]{umxACEv()}} model to plot.}

\item{file}{The name of the dot file to write: Default ("name") = use the name of the model. NA = don't plot.}

\item{digits}{How many decimals to include in path loadings (default = 2)}

\item{means}{Whether to show means paths (default = FALSE)}

\item{std}{Whether to standardize the model (default = FALSE)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Additional (optional) parameters}
}
\value{
\itemize{
\item optionally return the dot code
}
}
\description{
Plots an ACE model graphically, opening the result in the browser (or a graphviz application).
}
\examples{

\dontrun{
require(umx)
data(twinData)
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m1 = umxACEv(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")
umxSummary(m1)
umxPlotACEv(m1, std = FALSE) # Don't standardize
plot(m1, std = FALSE) # don't standardize
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Plotting functions: 
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umxPlot}()},
\code{\link{umx}}
}
\concept{Plotting functions}
