% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryACEcov}
\alias{umxSummaryACEcov}
\alias{umxSummary.MxModelACEcov}
\title{Present results of a twin ACE-model with covariates in table and graphical forms.}
\usage{
umxSummaryACEcov(
  model,
  digits = 2,
  showRg = FALSE,
  std = TRUE,
  comparison = NULL,
  CIs = TRUE,
  zero.print = ".",
  report = c("markdown", "html"),
  file = getOption("umx_auto_plot"),
  returnStd = FALSE,
  extended = FALSE,
  ...
)
}
\arguments{
\item{model}{a \code{\link[=umxACEcov]{umxACEcov()}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{std}{= whether to show the standardized model (TRUE)}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{CIs}{Whether to show Confidence intervals if they exist (TRUE)}

\item{zero.print}{How to show zeros (".")}

\item{report}{If "html", then open an html table of the results.}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{...}{Other parameters to control model summary}
}
\value{
\itemize{
\item optional \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Summarize a Cholesky model with covariates, as returned by \code{\link[=umxACEcov]{umxACEcov()}}
}
\examples{
require(umx)
data(twinData)
selDVs = c("bmi1", "bmi2")
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
\dontrun{
umxSummaryACE(m1, file = NA)
umxSummaryACE(m1, file = "name", std = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE)
}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxACEcov]{umxACEcov()}}
}

Other Summary functions: 
\code{\link{umxSummary.MxModel}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()}
}
\concept{Summary functions}
