% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxGetParameters}
\alias{umxGetParameters}
\title{Get parameters from a model, with support for pattern matching!}
\usage{
umxGetParameters(
  inputTarget,
  regex = NA,
  free = NA,
  fetch = c("values", "free", "lbound", "ubound", "all"),
  verbose = FALSE
)
}
\arguments{
\item{inputTarget}{An object to get parameters from: could be a RAM \code{\link[=mxModel]{mxModel()}}}

\item{regex}{A regular expression to filter the labels. Default (NA) returns all labels. If vector, treated as raw labels to find.}

\item{free}{A Boolean determining whether to return only free parameters.}

\item{fetch}{What to return: "values" (default) or "free", "lbound", "ubound", or "all"}

\item{verbose}{How much feedback to give}
}
\description{
umxGetParameters retrieves parameter labels from a model, like \code{\link[=omxGetParameters]{omxGetParameters()}}.
However, it is supercharged with regular expressions, so you can get labels that match a pattern.
}
\details{
In addition, if regex contains a vector, this is treated as a list of raw labels to search for,
and return if all are found.
\emph{note}: To return all labels, just leave regex as is.
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)

# Show all parameters
umxGetParameters(m1)
umxGetParameters(m1, free = TRUE)  # Only free parameters
umxGetParameters(m1, free = FALSE) # Only fixed parameters
# Complex regex pattern
umxGetParameters(m1, regex = "x[1-3]_with_x[2-5]", free = TRUE)

}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
\code{\link[=omxGetParameters]{omxGetParameters()}}, \code{\link[=parameters]{parameters()}}

Other Reporting Functions: 
\code{\link{loadings.MxModel}()},
\code{\link{umxAPA}()},
\code{\link{umxFactorScores}()},
\code{\link{umxParameters}()},
\code{\link{umxReduce}()},
\code{\link{umx_aggregate}()},
\code{\link{umx_names}()},
\code{\link{umx_time}()},
\code{\link{umx}}
}
\concept{Reporting Functions}
