% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoC.R
\name{umxDoC}
\alias{umxDoC}
\title{Build and run a 2-group Direction of Causation twin models.}
\usage{
umxDoC(
  name = "DoC",
  var1Indicators,
  var2Indicators,
  mzData = NULL,
  dzData = NULL,
  sep = "_T",
  causal = TRUE,
  autoRun = getOption("umx_auto_run"),
  intervals = FALSE,
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{name}{The name of the model (defaults to "DOC").}

\item{var1Indicators}{variables defining latent trait 1}

\item{var2Indicators}{variables defining latent trait 2}

\item{mzData}{The MZ dataframe}

\item{dzData}{The DZ dataframe}

\item{sep}{The separator in twin variable names, default = "_T", e.g. "dep_T1".}

\item{causal}{whether to add the causal paths (default TRUE)}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{intervals}{Whether to run mxCI confidence intervals (default = FALSE)}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing).}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}} of subclass MxModelDoC
}
}
\description{
Testing causal claims is often difficult due to an inability to conduct experimental randomization of traits and situations to people.
When twins are available, even when measured on a single occasion, the pattern of cross-twin cross-trait correlations
can (given distinguishable modes of inheritance for the two traits) falsify causal hypotheses.

\code{umxDoC} implements a 2-group model to form latent variables for each of two traits, and allows testing whether
trait 1 causes trait 2, vice-versa, or even reciprocal causation.

The following figure shows how the DoC model appears as a path diagram (for two latent variables X and Y,
each with three indicators). Note: For pedagogical reasons, only the model for 1 twin is shown, and only one DoC pathway drawn.

\if{html}{\figure{DoC.png}{options: width="50\%" alt="Figure: Direction of Causation"}}
\if{latex}{\figure{DoC.pdf}{options: width=7cm}}
}
\details{
To be added.
}
\examples{
\dontrun{
# ========================
# = Does Rain cause Mud? =
# ========================

# =======================================
# = 2. Define manifests for var 1 and 2 =
# =======================================
var1 = paste0("varA", 1:3)
var2 = paste0("varB", 1:3)

# ================
# = 1. Load Data =
# ================
data(docData)
docData = umx_scale_wide_twin_data(c(var1, var2), docData, sep= "_T")
mzData  = subset(docData, zygosity \%in\% c("MZFF", "MZMM"))
dzData  = subset(docData, zygosity \%in\% c("DZFF", "DZMM"))

# =======================================================
# = 2. Make the non-causal (Cholesky) and causal models =
# =======================================================
Chol = umxDoC(var1= var1, var2= var2, mzData= mzData, dzData= dzData, causal= FALSE)
DoC  = umxDoC(var1= var1, var2= var2, mzData= mzData, dzData= dzData, causal= TRUE)

# ================================================
# = Make the directional models by modifying DoC =
# ================================================
a2b   = umxModify(DoC, "a2b", free = TRUE, name = "a2b"); summary(a2b)
b2a   = umxModify(DoC, "b2a", free = TRUE, name = "b2a"); summary(b2a)
Recip = umxModify(DoC, c("a2b", "b2a"), free = TRUE, name = "Recip"); summary(Recip)

var1 = paste0("SOS", 1:8)
var2 = paste0("Vocab", 1:10)
Chol = umxDoC(var1= var1, var2= var2,mzData= mzData, dzData= dzData, causal= FALSE)
DoC  = umxDoC(var1= var1, var2= var2, mzData= mzData, dzData= dzData, causal= TRUE)
a2b  = umxModify(DoC, "a2b", free = TRUE, name = "a2b")
b2a  = umxModify(DoC, "b2a", free = TRUE, name = "b2a")
Recip= umxModify(DoC, c("a2b", "b2a"), free = TRUE, name = "Recip")
umxCompare(Chol, c(a2b, b2a, Recip))

}

}
\references{
\itemize{
\item N.A. Gillespie and N.G. Martin (2005). Direction of Causation Models.
In \emph{Encyclopedia of Statistics in Behavioral Science}, \strong{1}. 496–499. Eds. Brian S. Everitt & David C. Howell.
}
}
\seealso{
\itemize{
\item \code{\link[=plot.MxModelDoC]{plot.MxModelDoC()}}, \code{\link[=umxSummary.MxModelDoC]{umxSummary.MxModelDoC()}}, \code{\link[=umxModify]{umxModify()}}
}

Other Twin Modeling Functions: 
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
