% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{plot.MxLISRELModel}
\alias{plot.MxLISRELModel}
\title{Create and display a graphical path diagram for a LISREL model.}
\usage{
\method{plot}{MxLISRELModel}(
  x = NA,
  std = FALSE,
  fixed = TRUE,
  means = TRUE,
  digits = 2,
  file = "name",
  labels = c("none", "labels", "both"),
  resid = c("circle", "line", "none"),
  strip_zero = TRUE,
  ...
)
}
\arguments{
\item{x}{A LISREL \code{\link[=mxModel]{mxModel()}} from which to make a path diagram}

\item{std}{Whether to standardize the model (default = FALSE).}

\item{fixed}{Whether to show fixed paths (defaults to TRUE)}

\item{means}{Whether to show means or not (default = TRUE)}

\item{digits}{The number of decimal places to add to the path coefficients}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{labels}{Whether to show labels on the paths. both will show both the parameter and the label. ("both", "none" or "labels")}

\item{resid}{How to show residuals and variances default is "circle". Options are "line" & "none"}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional parameters}
}
\description{
\code{plot.MxLISRELModel} produces SEM diagrams using \code{\link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR()}} (or a graphviz application) to create the image.
}
\details{
\emph{Note:} By default, plots open in your browser (or plot pane if using RStudio).

\strong{Opening in an external editor/app}

The underlying format is graphviz.
If you use \code{umx_set_plot_format("graphviz")}, figures will open in a graphviz helper app (if installed).
If you use graphviz, we try and use that app, but YOU HAVE TO INSTALL IT!

On MacOS, you may need to associate the \sQuote{.gv} extension with your graphviz app.
Find the .gv file made by plot, get info (cmd-I), then choose \dQuote{open with},
select graphviz.app (or OmniGraffle professional),
then set \dQuote{change all}.

The commercial application \dQuote{OmniGraffle} is great for editing these images.
}
\examples{
# plot()
# TODO get LISREL example model
# Figure out how to map its matrices to plot. Don't do without establishing demand.
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}, \url{https://en.wikipedia.org/wiki/DOT_(graph_description_language)}
}
}
\seealso{
\itemize{
\item \code{\link[=umx_set_plot_format]{umx_set_plot_format()}}, \code{\link[=umx_set_auto_plot]{umx_set_auto_plot()}}, \code{\link[=umx_set_plot_format]{umx_set_plot_format()}}, \code{\link[=plot.MxModel]{plot.MxModel()}}, \code{\link[=umxPlotACE]{umxPlotACE()}}, \code{\link[=umxPlotCP]{umxPlotCP()}}, \code{\link[=umxPlotIP]{umxPlotIP()}}, \code{\link[=umxPlotGxE]{umxPlotGxE()}}
}

Other umx S3 functions: 
\code{\link{plot.MxModel}()}

Other Plotting functions: 
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umx}}
}
\concept{Plotting functions}
\concept{umx S3 functions}
