% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryCP}
\alias{umxSummaryCP}
\alias{umxSummary.MxModelCP}
\title{Present the results of a Common-pathway twin model in table and graphical form}
\usage{
umxSummaryCP(model, digits = 2, std = TRUE, CIs = FALSE,
  showRg = FALSE, comparison = NULL, report = c("markdown", "html"),
  file = getOption("umx_auto_plot"), returnStd = FALSE, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxCP}} model to summarize}

\item{digits}{Round to how many digits (default = 2)}

\item{std}{Whether to show the standardized model (TRUE) (ignored: used extended = TRUE to get unstandardized)}

\item{CIs}{Confidence intervals (default FALSE)}

\item{showRg}{Whether to show the genetic correlations (default FALSE)}

\item{comparison}{Run mxCompare on a comparison model (default NULL)}

\item{report}{Print tables to the console (as 'markdown'), or open in browser ('html')}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarizes a Common-Pathway model, as returned by \code{\link{umxCP}}
}
\examples{
\dontrun{
require(umx)
umx_set_optimizer("SLSQP")
data(twinData)
twinData$wt1 = twinData$wt1/10
twinData$wt2 = twinData$wt2/10
selDVs = c("ht", "wt")
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
umx_set_auto_plot(FALSE) # turn off autoplotting for CRAN
m1 = umxCP(selDVs = selDVs, dzData = dzData, mzData = mzData, sep = "", optimizer = "SLSQP")
umxSummaryCP(m1, file = NA) # Suppress plot creation with file
umxSummary(m1, file = NA)   # Generic summary is the same
stdFit = umxSummaryCP(m1, digits = 2, std = TRUE, file = NA, returnStd = TRUE);
umxSummary(m1, std = FALSE, showRg = TRUE, file = NA);
umxSummary(m1, std = FALSE, file = NA)
# =================
# = Print example =
# =================
umxSummary(m1, file = "Figure 3", std = TRUE)
# =================
# = Confint example =
# =================
m1 = umxConfint(m1, "smart", run = FALSE);
m1 = umxConfint(m1, "smart", run = TRUE);
umxSummary(m1, CIs = TRUE, file = NA);
}

}
\references{
- \url{https://www.github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umxCP}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEnew}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCPold}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPnew}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
\concept{Twin Modeling Functions}
