% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxExpCov}
\alias{umxExpCov}
\alias{vcov.MxModel}
\title{Get the expected vcov matrix}
\usage{
umxExpCov(object, latents = FALSE, manifests = TRUE, digits = NULL,
  ...)
}
\arguments{
\item{object}{an \code{\link{mxModel}} to get the covariance matrix from}

\item{latents}{Whether to select the latent variables (defaults to TRUE)}

\item{manifests}{Whether to select the manifest variables (defaults to TRUE)}

\item{digits}{precision of reporting. NULL (Default) = no rounding.}

\item{...}{extra parameters (to match \code{\link{vcov}})}
}
\value{
- expected covariance matrix
}
\description{
Extract the expected covariance matrix from an \code{\link{mxModel}}
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
vcov(m1)
umxExpCov(m1, digits = 3)
}
\references{
- \url{https://openmx.ssri.psu.edu/thread/2598}
Original written by \url{https://openmx.ssri.psu.edu/users/bwiernik}
}
\seealso{
- \code{\link{umxRun}}, \code{\link{umxCI_boot}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
\concept{Reporting functions}
