% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotCP}
\alias{umxPlotCP}
\alias{plot.MxModelCP}
\title{Draw and display a graphical figure of Common Pathway model}
\usage{
umxPlotCP(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, format = c("current", "graphviz", "DiagrammeR"), ...)
}
\arguments{
\item{x}{The Common Pathway \code{\link{mxModel}} to display graphically}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{...}{Optional additional parameters}
}
\value{
- Optionally return the dot code
}
\description{
Options include digits (rounding), showing means or not, and which output format is desired.
}
\examples{
\dontrun{
plot(yourCP_Model) # no need to remember a special name: plot works fine!
}
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxCP}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCPnew}},
  \code{\link{umxPlotGxEbiv}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxPlotSimplex}},
  \code{\link{umx}}
}
