% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_model_needs_means}
\alias{xmu_model_needs_means}
\title{Check data to see if model needs means.}
\usage{
xmu_model_needs_means(data, type = c("Auto", "FIML", "cov", "cor", "WLS",
  "DWLS", "ULS"), allContinuousMethod = c("cumulants", "marginals"))
}
\arguments{
\item{data}{\code{\link{mxData}} to check.}

\item{type}{of the data requested by the model.}

\item{allContinuousMethod}{How data will be processed if used for WLS.}
}
\value{
- T/F
}
\description{
Check data to see if model needs means.
}
\examples{
xmu_model_needs_means(mtcars, type = "Auto")
xmu_model_needs_means(mtcars, type = "FIML")
# xmu_model_needs_means(mtcars, type = "cov")
# xmu_model_needs_means(mtcars, type = "cor")

# TRUE - marginals means means
xmu_model_needs_means(mtcars, type = "WLS", allContinuousMethod= "marginals")
xmu_model_needs_means(mtcars, type = "ULS", allContinuousMethod= "marginals")
xmu_model_needs_means(mtcars, type = "DWLS", allContinuousMethod= "marginals")

# ================================
# = Provided as an mxData object =
# ================================
tmp = mxData(mtcars, type="raw")
xmu_model_needs_means(tmp, type = "FIML") # TRUE
xmu_model_needs_means(tmp, type = "ULS", allContinuousMethod= "cumulants") #FALSE
# TRUE - means with marginals
xmu_model_needs_means(tmp, type = "WLS", allContinuousMethod= "marginals")
tmp = mxData(cov(mtcars), type="cov", numObs= 100)
# Should catch this can't be type FIML
xmu_model_needs_means(tmp) # FALSE
tmp = mxData(cov(mtcars), means = umx_means(mtcars), type="cov", numObs= 100)
xmu_model_needs_means(tmp) # TRUE

# =======================
# = One var is a factor =
# =======================
tmp = mtcars
tmp$cyl = factor(tmp$cyl)
xmu_model_needs_means(tmp, allContinuousMethod= "cumulants") # TRUE
xmu_model_needs_means(tmp, allContinuousMethod= "marginals") # TRUE - always has means
}
\seealso{
- \code{\link{xmu_make_mxData}}

Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_assemble_twin_supermodel}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_clean_label}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_dot_maker}},
  \code{\link{xmu_dot_move_ranks}},
  \code{\link{xmu_dot_rank_str}},
  \code{\link{xmu_lavaan_process_group}},
  \code{\link{xmu_make_mxData}},
  \code{\link{xmu_make_top_twin}},
  \code{\link{xmu_safe_run_summary}},
  \code{\link{xmu_set_sep_from_suffix}},
  \code{\link{xmu_simplex_corner}},
  \code{\link{xmu_start_value_list}},
  \code{\link{xmu_starts}}
}
\concept{xmu internal not for end user}
