% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxSuperModel}
\alias{umxSuperModel}
\title{Make a multi-group model}
\usage{
umxSuperModel(name = "top", ..., autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "mxTryHard", "mxTryHardOrdinal",
  "mxTryHardWideSearch"))
}
\arguments{
\item{name}{The name for the container model (default = 'top')}

\item{...}{Models forming the multiple groups contained in the supermodel.}

\item{autoRun}{Whether to run the model, and return that (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "mxTryHardOrdinal", "mxTryHardWideSearch"}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxSuperModel takes 1 or more models and wraps them in a supermodel with a
\code{\link{mxFitFunctionMultigroup}} fit function that minimizes the sum of the
fits of the sub-models.
}
\examples{
library(umx)
# Create two sets of data in which X & Y correlate ~ .4 in both datasets.
tmp = umx_make_TwinData(nMZpairs = 100, nDZpairs = 150, 
		AA = 0, CC = .4, EE = .6, varNames = c("x", "y"))

# Group 1
ds1 = tmp[[1]];
m1Data = mxData(cov(ds1), type = "cov", numObs = nrow(ds1), means=umx_means(ds1))

# Group 2
ds2 = tmp[[2]];
m2Data = mxData(cov(ds2), type = "cov", numObs = nrow(ds2), means=umx_means(ds2))
cor(ds1); cor(ds2)

manifests = names(ds1)

# Model 1
m1 <- umxRAM("m1", data = m1Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels = c("Var_x", "Resid_y_grp1")),
	umxPath(means = manifests, labels = c("Mean_x", "Mean_y"))
)
# Model 2
m2 <- umxRAM("m2", data = m2Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels=c("Var_x", "Resid_y_grp2")),
	umxPath(means = manifests, labels=c("Mean_x", "Mean_y"))
)
# Place m1 and m2 into a supermodel, and autoRun it
# NOTE: umxSummary is only semi-smart/certain enough to compute saturated models etc
# and report multiple groups correctly.
m3 = umxSuperModel('top', m1, m2)

umxSummary(m3, show = "std")

# |name         | Std.Estimate| Std.SE|CI                |
# |:------------|------------:|------:|:-----------------|
# |beta         |         0.51|   0.05|0.51 [0.41, 0.61] |
# |Var_x        |         1.00|   0.00|1 [1, 1]          |
# |Resid_y_grp1 |         0.74|   0.05|0.74 [0.64, 0.84] |
# |beta         |         0.50|   0.05|0.5 [0.41, 0.6]   |
# |Var_x        |         1.00|   0.00|1 [1, 1]          |
# |Resid_y_grp2 |         0.75|   0.05|0.75 [0.65, 0.84] |

summary(m3)

}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{mxFitFunctionMultigroup}}, \code{\link{umxRAM}}

Other Core Modeling Functions: \code{\link{plot.MxLISRELModel}},
  \code{\link{plot.MxModel}}, \code{\link{umxAlgebra}},
  \code{\link{umxMatrix}}, \code{\link{umxModify}},
  \code{\link{umxPath}}, \code{\link{umxRAM}},
  \code{\link{umxRun}}, \code{\link{umx}}
}
\concept{Core Modeling Functions}
