% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxPath}
\alias{umxPath}
\title{Easier (and powerful) specification of paths in SEM.}
\usage{
umxPath(from = NULL, to = NULL, with = NULL, var = NULL,
  cov = NULL, means = NULL, v1m0 = NULL, v.m. = NULL,
  v0m0 = NULL, v.m0 = NULL, fixedAt = NULL, freeAt = NULL,
  firstAt = NULL, unique.bivariate = NULL, unique.pairs = NULL,
  fromEach = NULL, forms = NULL, Cholesky = NULL, defn = NULL,
  connect = c("single", "all.pairs", "all.bivariate", "unique.pairs",
  "unique.bivariate"), arrows = 1, free = TRUE, values = NA,
  labels = NA, lbound = NA, ubound = NA, hasMeans = NULL)
}
\arguments{
\item{from}{One or more source variables e.g "A" or c("A","B")}

\item{to}{One or more target variables for one-headed paths, e.g "A" or c("A","B").}

\item{with}{2-headed path <--> from 'from' to 'with'.}

\item{var}{Equivalent to setting 'from' and 'arrows' = 2. nb: from, to, and with must be left empty.}

\item{cov}{Convenience to allow 2 variables to covary (equivalent to 'from' and 'with'). nb: leave from, to, etc. empty}

\item{means}{equivalent to "from = 'one', to = x. nb: from, to, with and var must be left empty (their default).}

\item{v1m0}{variance of 1 and mean of zero in one call.}

\item{v.m.}{variance and mean, both free.}

\item{v0m0}{variance and mean, both fixed at zero.}

\item{v.m0}{variance free, mean fixed at zero.}

\item{fixedAt}{Equivalent to setting "free = FALSE, values = x" nb: free and values must be left empty (their default)}

\item{freeAt}{Equivalent to setting "free = TRUE, values = x" nb: free and values must be left empty (their default)}

\item{firstAt}{first value is fixed at this (values passed to free are ignored: warning if not a single TRUE)}

\item{unique.bivariate}{equivalent to setting from, and "connect = "unique.bivariate", arrows = 2".
nb: from, to, and with must be left empty (their default)}

\item{unique.pairs}{equivalent to setting "connect = "unique.pairs", arrows = 2" (don't use from, to, or with)}

\item{fromEach}{Like all.bivariate, but with one head arrows. 'to' can be set.}

\item{forms}{Build a formative variable. 'from' variables form the latent.
Latent variance is fixed at 0. Loading of path 1 is fixed at 1. unique.bivariate between 'from' variables.}

\item{Cholesky}{Treat \strong{Cholesky} variables as latent and \strong{to} as measured, and connect as in an ACE model.}

\item{defn}{Makes a latent variable, var@0 mean fixed, set label to 'data.<defn>'}

\item{connect}{as in mxPath - nb: Only used when using from and to}

\item{arrows}{as in mxPath - nb: Only used when using from and to}

\item{free}{whether the value is free to be optimised}

\item{values}{default value list}

\item{labels}{labels for each path}

\item{lbound}{lower bounds for each path value}

\item{ubound}{upper bounds for each path value}

\item{hasMeans}{Used in 'forms' case to know whether the data have means or not.}
}
\value{
- 1 or more \code{\link{mxPath}}s
}
\description{
The goal of this function is to enable quick-to-write, quick-to-read, flexible path descriptions for RAM models in OpenMx.

It introduces the following new words to our vocabulary for describing paths: \strong{with}, \strong{var}, \strong{cov}, \strong{means}, \strong{v1m0}, \strong{v0m0,} \strong{v.m0}, \strong{v.m.}, \strong{fixedAt}, \strong{freeAt}, \strong{firstAt}, \strong{unique.bivariate}, \strong{unique.pairs}, \strong{fromEach}, \strong{Cholesky}, \strong{defn}, \strong{forms}.

The new preposition \dQuote{with} means you no-longer need set arrows = 2 on covariances. Instead, you can say:

   \code{umxPath(A, with = B)} instead of \code{mxPath(from = A, to = B, arrows = 2)}.

Specify a variance for A with

\code{umxPath(var = "A")}.

This is equivalent to \code{mxPath(from = "A", to = "A", arrows = 2)}.

Of course you can use vectors anywhere:

\code{umxPath(var = c('N','E', 'O'))}

To specify a mean, you just say

\code{umxPath(mean = "A")}, which is equivalent to \code{mxPath(from = "one", to = "A")}.

To fix a path at a value, you can say:

\code{umxPath(var = "A", fixedAt = 1)} .

instead of \code{mxPath(from = A, to = A, arrows = 2, free = FALSE, values = 1)} 

The common task of creating a variable with variance fixed at 1 and mean at 0 is done thus:

\code{umxPath(v1m0 = "A")}

For free variance and means use:

\code{umxPath(v.m. = "A")}

umxPath exposes \dQuote{unique.bivariate} and \dQuote{unique.pairs} so you don't have to remember
how to fill in connect = in mxPath (you can still use connect if you wish).

So, to create paths creates A<->A, B<->B, and A->B, you would say:

\code{umxPath(unique.pairs = c('A',"B"))} 

To create paths A<->B, B<->C, and A<->C, you would say:
\code{umxPath(unique.bivariate = c('A',"B","C"))}

\code{umxPath(fromEach = c('A',"B","C"))} Creates one-headed arrows on the all.bivariate pattern


Setting up a latent trait, you can scale with a fixed first path thus:

\code{umxPath("A", to = c("B","C","D"),  firstAt = 1)}  

This is equivalent to \code{mxPath(from = A, to = c(B,C,D), free = c(F, T, T), values = c(1, .5, .4))}.

To create Cholesky-pattern connections:

\code{umxPath(Cholesky = c("A1", "A2"), to c("var1", "var2"))}

Finally, not implemented in this release, but intended for the future is
John Fox "sem"-package style notation,

i.e., "A -> B; X <-> B; "
}
\details{
This function returns a standard mxPath, but gives new options for specifying the path. In addition to the normal
\dQuote{from} and \dQuote{to}, it adds specialised parameters for variances (var), two headed paths (with) and means (mean).
There are also new terms to describe fixing values: \dQuote{fixedAt} and \dQuote{fixFirst}.

Finally, (in future) it will allow sem-style \dQuote{A->B} string specification.
}
\examples{
# A worked example
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("One Factor", data = myData,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
umxSummary(m1, show = "std")
require(umx)
#
# Examples of each path type, and option
umxPath("A", to = "B") # One-headed path from A to B
umxPath("A", to = "B", fixedAt = 1) # same, with value fixed @1
umxPath("A", to = c("B", "C"), fixedAt = 1:2) # same, with more than 1 value
umxPath("A", to = LETTERS[2:4], firstAt = 1) # Fix only the first path, others free
umxPath(var = "A") # Give a variance to A
umxPath(var = "A", fixedAt = 1) # Give a variance, fixed at 1
umxPath(var = LETTERS[1:5], fixedAt = 1)
umxPath(means = c("A","B")) # Create a means model for A: from = "one", to = "A"
umxPath(v1m0 = "A") # Give "A" variance and a mean, fixed at 1 and 0 respectively
umxPath(v.m. = "A") # Give "A" variance and a mean, leaving both free.
umxPath("A", with = "B") # using with: same as "to = B, arrows = 2"
umxPath("A", with = "B", fixedAt = .5) # 2-head path fixed at .5
umxPath("A", with = c("B", "C"), firstAt = 1) # first covariance fixed at 1
umxPath(cov = c("A", "B"))  # Covariance A <-> B
umxPath(unique.bivariate = letters[1:4]) # bivariate paths a<->b, a<->c, a<->d, b<->c etc.
umxPath(fromEach = letters[1:4]) # bivariate paths a<->b, a<->c, a<->d, b<->c etc.
umxPath(unique.pairs = letters[1:4]) # bivariate paths a<->b, a<->c, a<->d, b<->c etc.
umxPath(Cholesky = c("A1","A2"), to = c("m1", "m2")) # Cholesky

# ====================
# = Cholesky example =
# ====================
\dontrun{
latents   = paste0("A", 1:3)
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("Chol", data = myData,
	umxPath(Cholesky = latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
}

# The following NOT YET implemented!!
# umxPath("A <-> B") # same path as above using a string
# umxPath("A -> B") # one-headed arrow with string syntax
# umxPath("A <> B; A <-- B") # This is ok too
# umxPath("A -> B; B>C; C --> D") # two paths. white space and hyphens not needed
# # manifests is a reserved word, as is latents.
# # It allows the string syntax to use the manifestVars variable
# umxPath("A -> manifests") 
}
\references{
- \url{https://tbates.github.io}
}
\seealso{
- \code{\link{mxPath}}

Other Core Modeling Functions: \code{\link{plot.MxLISRELModel}},
  \code{\link{plot.MxModel}}, \code{\link{umxAlgebra}},
  \code{\link{umxMatrix}}, \code{\link{umxModify}},
  \code{\link{umxRAM}}, \code{\link{umxRun}},
  \code{\link{umxSuperModel}}, \code{\link{umx}}
}
\concept{Core Modeling Functions}
