% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxIP}
\alias{umxIP}
\title{umxIP: Build and run an Independent pathway twin model}
\usage{
umxIP(name = "IP", selDVs, dzData, mzData, suffix = NULL, nFac = 1,
  freeLowerA = FALSE, freeLowerC = FALSE, freeLowerE = FALSE,
  equateMeans = TRUE, dzAr = 0.5, dzCr = 1, correlatedA = FALSE,
  addStd = TRUE, addCI = TRUE, numObsDZ = NULL, numObsMZ = NULL,
  autoRun = getOption("umx_auto_run"), optimizer = NULL, sep = NULL)
}
\arguments{
\item{name}{The name of the model (defaults to "IP")}

\item{selDVs}{The variables to include}

\item{dzData}{The DZ dataframe}

\item{mzData}{The MZ dataframe}

\item{suffix}{The suffix for twin 1 and twin 2, often "_T". If set, you can
omit suffixes in selDVs, i.e., just "dep" not c("dep_T1", "dep_T2")}

\item{nFac}{How many common factors (default = 1)}

\item{freeLowerA}{Whether to leave the lower triangle of A free (default = F)}

\item{freeLowerC}{Whether to leave the lower triangle of C free (default = F)}

\item{freeLowerE}{Whether to leave the lower triangle of E free (default = F)}

\item{equateMeans}{Whether to equate the means across twins (defaults to T)}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating)}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model)}

\item{correlatedA}{Whether factors are allowed to correlate (not implemented yet: FALSE)}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE)}

\item{addCI}{Whether to add the interval requests for CIs (defaults to TRUE)}

\item{numObsDZ}{= TODO: implement ordinal Number of DZ twins: Set this if you input covariance data}

\item{numObsMZ}{= TODO: implement ordinal Number of MZ twins: Set this if you input covariance data}

\item{autoRun}{Whether to mxRun the model (default TRUE: the estimated model will be returned)}

\item{optimizer}{optionally set the optimizer (default NULL does nothing)}

\item{sep}{allowed as a synonym for "suffix"}
}
\value{
- \code{\link{mxModel}}
}
\description{
Make a 2-group Independent Pathway twin model (Common-factor independent-pathway multivariate model)
The following figure shows the IP model diagrammatically:
\figure{IP.png}
}
\examples{
require(umx)
data(twinData)
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
selDVs = c("ht", "wt") # These will be expanded into "ht1" "ht2"
m1 = umxIP(selDVs = selDVs, suffix = "", dzData = dzData, mzData = mzData)
# umxSummary(m1)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}},
  \code{\link{umxACE_cov_fixed}}, \code{\link{umxACEcov}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxReduceACE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_long2wide}}, \code{\link{umx_wide2long}},
  \code{\link{umx}}, \code{\link{xmu_twin_check}}
}
