% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_standardize_RAM}
\alias{umx_standardize_RAM}
\title{umx_standardize_RAM}
\usage{
umx_standardize_RAM(model, return = "parameters", Amatrix = NA,
  Smatrix = NA, Mmatrix = NA)
}
\arguments{
\item{model}{The \code{\link{mxModel}} you wish to standardise}

\item{return}{What to return. Valid options: "parameters", "matrices", or "model"}

\item{Amatrix}{Optionally tell the function what the name of the asymmetric matrix is (defaults to RAM standard A)}

\item{Smatrix}{Optionally tell the function what the name of the symmetric matrix is (defaults to RAM standard S)}

\item{Mmatrix}{Optionally tell the function what the name of the means matrix is (defaults to RAM standard M)}
}
\value{
- a \code{\link{mxModel}} or else parameters or matrices if you request those
}
\description{
umx_standardize_RAM takes a RAM-style model, and returns standardized version.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m1 = umx_standardize_RAM(m1, return = "model")
summary(m1)
}
\references{
- \url{http://github.com/tbates/umx}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}}
}
