% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_builders.r
\name{umxEFA}
\alias{umxEFA}
\alias{umxFactanal}
\title{umxEFA}
\usage{
umxEFA(x = NULL, factors = NULL, data = NULL, covmat = NULL,
  n.obs = NULL, rotation = c("varimax", "promax", "none"), name = "efa",
  digits = 2, report = c("1", "table", "html"))
}
\arguments{
\item{x}{Either 1: data, 2: A formula (not implemented yet), 3: A collection of variable names, or 4: A name for the model.}

\item{factors}{Either number of factors to request or a vector of factor names.}

\item{data}{A dataframe of manifest columns you are modeling}

\item{covmat}{Covariance matrix of data you are modeling (not implemented)}

\item{n.obs}{Number of observations in covmat (if provided, default = NA)}

\item{rotation}{A rotation to perform on the loadings (default  = "varimax" (orthogonal))}

\item{name}{A name for your model.}

\item{digits}{rounding (default = 2)}

\item{report}{What to report}
}
\value{
- EFA \code{\link{mxModel}}
}
\description{
Perform full-information maximum-likelihood factor analysis on a data matrix.
as in \code{\link{factanal}}, you need only specify the number of factors and offer up
some manifest data, e.g:
                                                             
umxEFA(factors = 2, data = mtcars)
}
\details{
Equivalently, you can also give a list of factor names:

umxEFA(factors = c("g", "v"), data = mtcars)

\figure{umxEFA.png}

\emph{notes}: In an EFA, all items may load on all factors.
For identification we need m^2 degrees of freedom. We get m * (m+1)/2 from fixing factor variances to 1 and covariances to 0.
We get another m(m-1)/2 degrees of freemdom by fixing the upper-right hand corner of the factor loadings
component of the A matrix. The manifest variances are also lbounded at 0.

EFA reports standardized loadings: to do this, we scale the data.

Bear in mind that factor scores are indeterminate and can be rotated.

This is very much early days. I will add "scores" if there is demand. Currently, you can
get scores from with \code{\link{mxFactorScores}}.

todo: detect ordinal items and switch to UWLS
}
\examples{
myVars <- c("mpg", "disp", "hp", "wt", "qsec")
m1 = umxEFA(mtcars[, myVars], factors =   2, rotation = "promax")
loadings(m1)
m2 = factanal(~ mpg + disp + hp + wt + qsec, factors = 2, rotation = "promax", data = mtcars)
loadings(m2)
\dontrun{
plot(m2)
m3 = umxEFA(myVars, factors = 2, data = mtcars, rotation = "promax")
m4 = umxEFA(name = "named", factors = "g", data = mtcars[, myVars])
m5 = umxEFA(name = "by_number", factors = 2, rotation = "promax", data = mtcars[, myVars])
}
}
\references{
- \url{http://github.com/tbates/umx}
}
\seealso{
- \code{\link{factanal}}

Other Super-easy helpers: \code{\link{umxTwoStage}},
  \code{\link{umx}}
}

