% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_grep}
\alias{umx_grep}
\title{umx_grep}
\usage{
umx_grep(df, grepString, output = c("both", "label", "name"),
  ignore.case = TRUE, useNames = FALSE)
}
\arguments{
\item{df}{The \code{\link{data.frame}} or string to search}

\item{grepString}{the search string}

\item{output}{the column name, the label, or both (default)}

\item{ignore.case}{whether to be case sensitive or not (default TRUE = ignore case)}

\item{useNames}{whether to search the names as well as the labels (for SPSS files with label metadata)}
}
\value{
- list of matched column names and/or labels
}
\description{
Search for text. Will search names if given a data.frame, or strings if given a vector of strings. 
NOTE: Handy feature is that this can search the labels of data imported from SPSS
}
\details{
To simply grep for a pattern in a string just use R built-in grep* functions, e.g.:
 grepl("^NA\\[0-9]", "NA.3")
}
\examples{
umx_grep(mtcars, "hp", output="both", ignore.case= TRUE)
umx_grep(c("hp", "ph"), "hp")
umx_grep(mtcars, "^h.*", output="both", ignore.case= TRUE)
\dontrun{
umx_grep(spss_df, "labeltext", output = "label") 
umx_grep(spss_df, "labeltext", output = "name") 
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{grep}} umx_aggregate

Other Utility Functions: \code{\link{qm}},
  \code{\link{umx_find_object}}, \code{\link{umx_msg}},
  \code{\link{umx_names}}, \code{\link{umx_paste_names}},
  \code{\link{umx_pb_note}}, \code{\link{umx_print}},
  \code{\link{umx_rename}}, \code{\link{umx}}
}

