% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotACEcov}
\alias{plot.MxModel.ACEcov}
\alias{umxPlotACEcov}
\title{umxPlotACEcov}
\usage{
umxPlotACEcov(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, showMeans = NULL, ...)
}
\arguments{
\item{x}{\code{\link{mxModel}} to plot (created by umxACE in order to inherit the MxModel.ACE class)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{means}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{showMeans}{(older parameter - replace with means)}

\item{...}{Additional (optional) parameters}
}
\value{
- optionally return the dot code
}
\description{
Make a graphical display of an ACE model
}
\examples{
require(umx)
# BMI ?twinData from Australian twins. 
# Cohort 1 Zygosity 1 == MZ females 3 == DZ females
data(twinData)
# Pick the variables. We will use base names (i.e., "bmi") and set suffix.
selDVs  = c("bmi")
selCovs = c("age")
selVars = umx_paste_names(c(selDVs, selCovs), sep = "", suffixes= 1:2)
# just top few pairs so example runs quickly
mzData = subset(twinData, zyg == 1, selVars)[1:100, ]
dzData = subset(twinData, zyg == 3, selVars)[1:100, ]
# TODO update for new dataset variable zygosity
# mzData = subset(twinData, zygosity == "MZFF", selVars)[1:200, ]
# dzData = subset(twinData, zygosity == "DZFF", selVars)[1:200, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs, dzData = dzData, mzData = mzData, 
	 suffix = "", autoRun = TRUE)
plot(m1)
plot(m1, std = FALSE) # don't standardize
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACE}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}

