% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxValues}
\alias{umxValues}
\title{umxValues}
\usage{
umxValues(obj = NA, sd = NA, n = 1, onlyTouchZeros = FALSE)
}
\arguments{
\item{obj}{The RAM or matrix \code{\link{mxModel}}, or \code{\link{mxMatrix}} that you want to set start values for.}

\item{sd}{Optional Standard Deviation for start values}

\item{n}{Optional Mean for start values}

\item{onlyTouchZeros}{Don't start things that appear to have already been started (useful for speeding \code{\link{umxReRun}})}
}
\value{
- \code{\link{mxModel}} with updated start values
}
\description{
umxValues will set start values for the free parameters in RAM and Matrix \code{\link{mxModel}}s, or even mxMatrices.
It will try and be smart in guessing these from the values in your data, and the model type.
If you give it a numeric input, it will use obj as the mean, return a list of length n, with sd = sd
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
mxEval(S, m1) # default variances are 0
m1 = umxValues(m1)
mxEval(S, m1) # plausible variances
umx_print(mxEval(S,m1), 3, zero.print = ".") # plausible variances
umxValues(14, sd = 1, n = 10) # Return vector of length 10, with mean 14 and sd 1
# todo: handle complex guided matrix value starts...
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- Core functions:

Other Model Building Functions: \code{\link{umxCP}};
  \code{\link{umxDiagnose}}; \code{\link{umxGxE}};
  \code{\link{umxIP}}; \code{\link{umxLabel}};
  \code{\link{umxLatent}}; \code{\link{umxPath}};
  \code{\link{umxRAM}}; \code{\link{umxReRun}};
  \code{\link{umxRun}}; \code{\link{umxThresholdMatrix}};
  \code{\link{umx_fix_first_loadings}};
  \code{\link{umx_fix_latents}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

