% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_APA_pval}
\alias{umx_APA_pval}
\title{umx_APA_pval}
\usage{
umx_APA_pval(p, min = 0.001, rounding = 3, addComparison = NA)
}
\arguments{
\item{p}{The p-value to round}

\item{min}{Values below min reported as "< min"}

\item{rounding}{Number of decimal to which to round}

\item{addComparison}{Whether to add '=' '<' etc. (NA adds when needed)}
}
\value{
- formatted p-value
}
\description{
round a p value so you get < .001 instead of .000000002 or 1.00E-09
}
\examples{
umx_APA_pval(.052347)
umx_APA_pval(1.23E-3)
umx_APA_pval(1.23E-4)
umx_APA_pval(c(1.23E-3, .5))
umx_APA_pval(c(1.23E-3, .5), addComparison = TRUE)
}
\seealso{
- \code{\link{round}}

Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_add_variances}};
  \code{\link{umx_apply}}; \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_paste_names}}; \code{\link{umx_print}};
  \code{\link{umx_rename}}; \code{\link{umx_reorder}};
  \code{\link{umx_rot}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}

Other Reporting Functions: \code{\link{umxStandardizeACE}};
  \code{\link{umx_APA_CI}}; \code{\link{umx_aggregate}};
  \code{\link{umx_print}}; \code{\link{umx_show}};
  \code{\link{umx_time}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

