% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxExpCov}
\alias{umxExpCov}
\title{umxExpCov}
\usage{
umxExpCov(model, latents = FALSE, manifests = TRUE, digits = NULL)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get the covariance matrix from}

\item{latents}{Whether to select the latent variables (defaults to TRUE)}

\item{manifests}{Whether to select the manifest variables (defaults to TRUE)}

\item{digits}{precision of reporting. Leave NULL to do no rounding.}
}
\value{
- expected covariance matrix
}
\description{
extract the expected covariance matrix from an \code{\link{mxModel}}
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umxExpCov(m1)
umxExpCov(m1, digits = 3)
}
\references{
- \url{http://openmx.psyc.virginia.edu/thread/2598}
Original written by \url{http://openmx.psyc.virginia.edu/users/bwiernik}
}
\seealso{
- \code{\link{umxRun}}, \code{\link{umxCI_boot}}

Other Reporting functions: \code{\link{RMSEA.MxModel}};
  \code{\link{RMSEA.summary.mxmodel}}; \code{\link{RMSEA}};
  \code{\link{coef.MxModel}};
  \code{\link{confint.MxModel}};
  \code{\link{extractAIC.MxModel}};
  \code{\link{logLik.MxModel}}; \code{\link{plot.MxModel}},
  \code{\link{umxPlot}}; \code{\link{plot}},
  \code{\link{plot.MxModel.ACE}}, \code{\link{umxPlotACE}};
  \code{\link{residuals.MxModel}};
  \code{\link{umxCI_boot}}; \code{\link{umxCI}};
  \code{\link{umxCompare}}; \code{\link{umxExpMeans}};
  \code{\link{umxFitIndices}};
  \code{\link{umxStandardizeModel}};
  \code{\link{umxSummary.MxModel}};
  \code{\link{umx_drop_ok}}
}

