% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_model.R
\name{run_dynamic_regression}
\alias{run_dynamic_regression}
\title{Run the dynamic regression model}
\usage{
run_dynamic_regression(train, test, params, alpha, calc_shaps)
}
\arguments{
\item{train}{Dataframe of train data as returned by the \code{\link[=split_data_counterfactual]{split_data_counterfactual()}}
function.}

\item{test}{Dataframe of test data as returned by the \code{\link[=split_data_counterfactual]{split_data_counterfactual()}}
function.}

\item{params}{list of hyperparameters to use in dynamic_regression call. Only uses ntrain to specify
the number of data points to use for training. Default is 8760 which results in
1 year of hourly data}

\item{alpha}{Confidence level of the prediction interval between 0 and 1.}

\item{calc_shaps}{Boolean value. If TRUE, calculate SHAP values for the
method used and format them so they can be visualised with \code{\link[shapviz:sv_importance]{shapviz:sv_importance()}} and
\code{\link[shapviz:sv_dependence]{shapviz:sv_dependence()}}.
The SHAP values are generated for a subset (or all, depending on the size of the dataset) of the
test data.}
}
\value{
Data frame of predictions and model
}
\description{
This function trains a dynamic regression model with fourier transformed temporal features
and meteorological variables as external regressors on the
specified training dataset and makes predictions on the test dataset in a
counterfactual scenario. This is referred to as a dynamic regression model in
\href{https://otexts.com/fpp3/dynamic.html}{Forecasting: Principles and Practise, Chapter 10 - Dynamic regression models}
}
\details{
Note: Runs the dynamic regression model for individualised use with own data pipeline.
Otherwise use \code{\link[=run_counterfactual]{run_counterfactual()}} to call this function.
}
