% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.mnps.R
\name{boxplot.mnps}
\alias{boxplot.mnps}
\title{Boxplot for `mnps` objects}
\usage{
\method{boxplot}{mnps}(
  x,
  stop.method = NULL,
  color = TRUE,
  figureRows = NULL,
  singlePlot = NULL,
  multiPage = FALSE,
  time = NULL,
  print = TRUE,
  ...
)
}
\arguments{
\item{x}{A `ps` object}

\item{stop.method}{Only 1 `stop.method` can be presented at a time for `mnps` objects. 
Use a numeric indicator of which `stop.method` (among those specified when fitting
the `mnps` object) should be used.}

\item{color}{If `FALSE`, a grayscale figure will be returned.}

\item{figureRows}{The number of rows in the figure. Defaults to the number of panels.}

\item{singlePlot}{If multiple sets of boxplots are produced, `singlePlot` can be used
to select only one. For example, `singlePlot = 2` would return only the second set
of boxplots.}

\item{multiPage}{When multiple frames of a figure are produced, `multiPage = TRUE` will
print each frame on a different page. This is intended for situations where the graphical
output is being saved to a file.}

\item{time}{For use with iptw fits.}

\item{print}{If `FALSE`, the figure is returned but not printed.}

\item{...}{Additional arguments that are passed to boxplot function, which may bepassed to
the underlying `lattice` package plotting functions.}
}
\description{
This function produces a collection of diagnostic plots for mnps objects.
}
\details{
This function produces lattice-style graphics of diagnostic plots.
}
\references{
Dan McCaffrey, G. Ridgeway, Andrew Morral (2004). "Propensity
  Score Estimation with Boosted Regression for Evaluating Adolescent
  Substance Abuse Treatment", *Psychological Methods* 9(4):403-425.
}
\seealso{
[mnps]
}
\keyword{multivariate}
