% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootci_tvmb.R
\name{bootci_tvmb}
\alias{bootci_tvmb}
\title{Bootstrap samples to estimate confidence intervals for the mediation effect for a binary 
outcome.}
\usage{
bootci_tvmb(treatment, t.seq, m, outcome, coeff_data, replicates = 1000)
}
\arguments{
\item{treatment}{a vector indicating treatment group}

\item{t.seq}{a vector of unique time points for each observation}

\item{m}{matrix of mediator values in wide format}

\item{outcome}{matrix of outcome values in wide format}

\item{coeff_data}{a merged dataset of indirect and direct effects and CIs estimated 
from \code{bootci_coeff_binary}}

\item{replicates}{number of replicates for bootstrapping CIs. Default = 1000.}
}
\value{
\item{timeseq}{time points of estimation}

\item{alpha_hat}{time-varying treatment effect on the mediator}

\item{CI.lower.a}{CI lower limit for estimated coefficient alpha_hat}

\item{CI.upper.a}{CI upper limit for estimated coefficient alpha_hat}

\item{gamma_hat}{time-varying treatment effect on the outcome (direct effect)}

\item{CI.lower.g}{CI lower limit for estimated coefficient gamma_hat}

\item{CI.upper.g}{CI upper limit for estimated coefficient gamma_hat}

\item{beta_hat}{time-varying effect of the mediator on the outcome}

\item{CI.lower.b}{CI lower limit for estimated coefficient beta_hat}

\item{CI.upper.b}{CI upper limit for estimated coefficient beta_hat}

\item{tau_hat}{time-varying treatment effect on outcome (total effect)}

\item{CI.lower.t}{CI lower limit for estimated coefficient tau_hat}

\item{CI.upper.t}{CI upper limit for estimated coefficient tau_hat}

\item{medEffect}{time varying mediation effect}

\item{CI.lower}{CI lower limit for medEffect}

\item{CI.upper}{CI upper limit for medEffect}
}
\description{
Part of the set of internal functions for estimating bootstrapped confidence intervals 
for the mediation effect for a binary outcome when user argument \code{CI="boot"}.
}
