% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsplot.R
\name{tsplot}
\alias{tsplot}
\title{Plot Time Series}
\usage{
tsplot(
  ...,
  tsr = NULL,
  ci = NULL,
  left_as_bar = FALSE,
  group_bar_chart = FALSE,
  relative_bar_chart = FALSE,
  left_as_band = FALSE,
  plot_title = NULL,
  plot_subtitle = NULL,
  plot_subtitle_r = NULL,
  find_ticks_function = "findTicks",
  overall_xlim = NULL,
  overall_ylim = NULL,
  manual_date_ticks = NULL,
  manual_value_ticks_l = NULL,
  manual_value_ticks_r = NULL,
  manual_ticks_x = NULL,
  theme = NULL,
  quiet = TRUE,
  auto_legend = TRUE,
  output_format = "plot",
  filename = "tsplot",
  close_graphics_device = TRUE
)
}
\arguments{
\item{...}{multiple objects of class ts or a list of time series. All objects passed through the ... parameter relate to the standard left y-axis.}

\item{tsr}{list of time series objects of class ts.}

\item{ci}{list of confidence intervals for time series}

\item{left_as_bar}{logical should the series that relate to the left bar be drawn as (stacked) bar charts?}

\item{group_bar_chart}{logical should a bar chart be grouped instead of stacked?}

\item{relative_bar_chart}{logical Should time series be normalized such that bars range from 0 to 1? Defaults to FALSE. That way every sub bar (time series) is related to the global max. Hence do not expect every single bar to reach 1. This works for stacked and grouped charts and does not change anything but the scale of the chart.}

\item{left_as_band}{logical Should the time series assigned to the left axis be displayed as stacked area charts?}

\item{plot_title}{character title to be added to the plot}

\item{plot_subtitle}{character subtitle to be added to the plot}

\item{plot_subtitle_r}{character second subtitle to be added at the top right}

\item{find_ticks_function}{function to compute ticks.}

\item{overall_xlim}{integer overall x-axis limits, defaults to NULL.}

\item{overall_ylim}{integer overall y-axis limits, defaults to NULL.}

\item{manual_date_ticks}{character vector of manual date ticks.}

\item{manual_value_ticks_l}{numeric vector, forcing ticks to the left y-axis}

\item{manual_value_ticks_r}{numeric vector, forcing ticks to the right y-axis}

\item{manual_ticks_x}{numeric vector, forcing ticks on the x axis}

\item{theme}{list of default plot output parameters. Defaults to NULL, which leads to \code{\link{init_tsplot_theme}} being called. Please see the vignette for details about tweaking themes.}

\item{quiet}{logical suppress output, defaults to TRUE.}

\item{auto_legend}{logical should legends be printed automatically, defaults to TRUE.}

\item{output_format}{character Should the plot be drawn on screen or written to a file? Possible values are "plot" for screen output and "pdf". Default "plot"}

\item{filename}{character Path to the file to be written if \code{output_format} is "pdf". Default "tsplot.pdf"}

\item{close_graphics_device}{logical Should the graphics device of the output file be closed after \code{tsplot}? Set this to FALSE to be able to make modifications to the plot after \code{tsplot} finishes. Default TRUE}
}
\description{
Conveniently plot time series.
}
\details{
The ci parameter is a 3-level list of the form
list(
 ts1 = list(
  ci_value_1 = list(
   ub = upper_bound_ts_object,
   lb = lower_bound_ts_object
  ),
  ...
 ),
 ...
)

See \code{vignette("tstools")} for details.
}
