% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dummies.R
\name{create_dummy_ts}
\alias{create_dummy_ts}
\title{Flexible Function to Create Time Series Dummy Variables}
\usage{
create_dummy_ts(
  end_basic,
  dummy_start,
  dummy_end = NULL,
  sp = T,
  start_basic = c(1980, 1),
  basic_value = 0,
  dummy_value = 1,
  frequency = 4
)
}
\arguments{
\item{end_basic}{numeric vector of form c(yyyy,p) defining the end of the time series.}

\item{dummy_start}{numeric vector of form c(yyyy,p) defining the beginning of the period with different value.}

\item{dummy_end}{numeric vector of form c(yyyy,p) defining the end of the period with different value. Defaults to NULL, using the end_date of the series.}

\item{sp}{logical should NULL value for dummy_end lead to a single period dummy (TRUE) or to alternative values until the end.}

\item{start_basic}{numeric vector of form c(yyyy,p) defining the start of the time series. Defaults to c(1980,1)}

\item{basic_value}{default value of the time series, defaults to 0.}

\item{dummy_value}{the alternative value, defaults to 1.}

\item{frequency}{integer frequency of the regular time series, defaults to 4 (quarterly).}
}
\description{
Generate time series with a default value that is changed within a certain subperiod. 
The function allows for additional convenience when specifying single period dummies and dummies that go from a certain point in time to the end of the series.
}
\author{
Matthias Bannert
}
