\name{morph_instances}
\alias{morph_instances}
\title{Morphing (convex-combination) of two instances with parameter alpha.}
\usage{
morph_instances(x, y, alpha)
}
\arguments{
  \item{x}{[\code{\link{tsp_instance}}]\cr}

  \item{y}{[\code{\link{tsp_instance}}]\cr}

  \item{alpha}{[\code{numeric(1)}]\cr Coefficient alpha for
  convex combination.}
}
\value{
[\code{\link{tsp_instance}}] Morphed TSP instance.
}
\description{
Pairs of cities are matched in a greedy fashion, see
\code{\link{greedy_point_matching}}.
}
\examples{
x = random_instance(10)
y = random_instance(10)
z = morph_instances(x, y, 0.5)
autoplot(x)
autoplot(y)
autoplot(z)
}

