% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-slide.R
\name{partial_slider}
\alias{partial_slider}
\alias{partial_pslider}
\title{Partially splits the input to a list according to the rolling window size.}
\usage{
partial_slider(
  .x,
  .size = 1,
  .step = 1,
  .fill = NA,
  .align = "right",
  .bind = FALSE
)

partial_pslider(
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .align = "right",
  .bind = FALSE
)
}
\arguments{
\item{.x}{An object to slide over.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.step}{A positive integer for calculating at every specified step
instead of every single step.}

\item{.fill}{A value to fill at the left/center/right of the data range depending
on \code{.align} (\code{NA} by default).  \code{NULL} means no filling.}

\item{.align}{Align index at the "\strong{r}ight", "\strong{c}entre"/"center", or "\strong{l}eft"
of the window. If \code{.size} is even for center alignment, "centre-right" & "centre-left"
is needed.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{...}{Additional arguments passed on to the mapped function.}
}
\description{
Partially splits the input to a list according to the rolling window size.
}
\examples{
x <- c(1, NA_integer_, 3:5)
slider(x, .size = 3)
partial_slider(x, .size = 3)
}
\keyword{internal}
