% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R, R/tidyr-verbs.R
\name{tsibble-tidyverse}
\alias{tsibble-tidyverse}
\alias{arrange.tbl_ts}
\alias{filter.tbl_ts}
\alias{slice.tbl_ts}
\alias{select.tbl_ts}
\alias{rename.tbl_ts}
\alias{mutate.tbl_ts}
\alias{transmute.tbl_ts}
\alias{summarise.tbl_ts}
\alias{gather.tbl_ts}
\alias{spread.tbl_ts}
\alias{nest.tbl_ts}
\title{Tidyverse methods for tsibble}
\usage{
\method{arrange}{tbl_ts}(.data, ...)

\method{filter}{tbl_ts}(.data, ..., .preserve = FALSE)

\method{slice}{tbl_ts}(.data, ..., .preserve = FALSE)

\method{select}{tbl_ts}(.data, ...)

\method{rename}{tbl_ts}(.data, ...)

\method{mutate}{tbl_ts}(.data, ...)

\method{transmute}{tbl_ts}(.data, ...)

\method{summarise}{tbl_ts}(.data, ...)

\method{gather}{tbl_ts}(data, key = "key", value = "value", ...,
  na.rm = FALSE, convert = FALSE, factor_key = FALSE)

\method{spread}{tbl_ts}(data, key, value, ...)

\method{nest}{tbl_ts}(.data, ...)
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{...}{Same arguments accepted as its tidyverse generic.}

\item{.preserve}{when \code{FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}

\item{data}{A data frame.}

\item{key}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:ensym]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{value}{Names of new key and value columns, as strings or
symbols.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:ensym]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{na.rm}{If \code{TRUE}, will remove rows from output where the
value column is \code{NA}.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link[=type.convert]{type.convert()}} on the key column. This is useful if the column
types are actually numeric, integer, or logical.}

\item{factor_key}{If \code{FALSE}, the default, the key values will be
stored as a character vector. If \code{TRUE}, will be stored as a factor,
which preserves the original ordering of the columns.}
}
\description{
\itemize{
\item \code{arrange()}: if not arranging key and index in past-to-future order, a warning is
likely to be issued.
\item \code{slice()}: if row numbers are not in ascending order, a warning is likely to
be issued.
\item \code{select()}: keeps the variables you mention as well as the index.
\item \code{transmute()}: keeps the variable you operate on, as well as the index and key.
\item \code{summarise()} reduces a sequence of values over time instead of a single summary,
as well as dropping empty keys/groups.
}
}
\details{
Column-wise verbs, including \code{select()}, \code{transmute()}, \code{summarise()},
\code{mutate()} & \code{transmute()}, keep the time context hanging around. That is,
the index variable cannot be dropped for a tsibble. If any key variable
is changed, it will validate whether it's a tsibble internally. Use \code{as_tibble()}
to leave off the time context.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
# Sum over sensors
pedestrian \%>\%
  index_by() \%>\%
  summarise(Total = sum(Count))
# shortcut
pedestrian \%>\%
  summarise(Total = sum(Count))
# Back to tibble
pedestrian \%>\%
  as_tibble() \%>\%
  summarise(Total = sum(Count))
library(tidyr)
# example from tidyr
stocks <- tsibble(
  time = as.Date("2009-01-01") + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)
(stocksm <- stocks \%>\% gather(stock, price, -time))
stocksm \%>\% spread(stock, price)
nested_stock <- stocksm \%>\%
  nest(-stock)
stocksm \%>\%
  group_by(stock) \%>\%
  nest()
}
