% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsibble-meta.R
\name{is_tsibble}
\alias{is_tsibble}
\alias{is.tsibble}
\alias{is_grouped_ts}
\alias{is.grouped_ts}
\title{If the object is a tsibble}
\usage{
is_tsibble(x)

is_grouped_ts(x)
}
\arguments{
\item{x}{An object.}
}
\value{
TRUE if the object inherits from the tbl_ts class.
}
\description{
\Sexpr[results=rd, stage=render]{tsibble:::lifecycle("stable")}
}
\examples{
# A tibble is not a tsibble ----
tbl <- tibble(
  date = seq(as.Date("2017-10-01"), as.Date("2017-10-31"), by = 1),
  value = rnorm(31)
)
is_tsibble(tbl)

# A tsibble ----
tsbl <- as_tsibble(tbl, index = date)
is_tsibble(tsbl)
}
