% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.R
\name{stretcher}
\alias{stretcher}
\alias{pstretcher}
\title{Split the input to a list according to the stretching window size.}
\usage{
stretcher(.x, .step = 1, .init = 1, .bind = FALSE)

pstretcher(..., .step = 1, .init = 1, .bind = FALSE)
}
\arguments{
\item{.x}{An objects to be split.}

\item{.step}{A positive integer for incremental step.}

\item{.init}{A positive integer for an initial window size.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{...}{Multiple objects to be split in parallel.}
}
\description{
Split the input to a list according to the stretching window size.
}
\examples{
x <- 1:5
y <- 6:10
z <- 11:15
lst <- list(x = x, y = y, z = z)
df <- as.data.frame(lst)

stretcher(x, .step = 2)
stretcher(lst, .step = 2)
stretcher(df, .step = 2)
pstretcher(df, df, .step = 2)
}
