% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-index.R
\name{filter_index}
\alias{filter_index}
\title{A shorthand for filtering time index for a tsibble}
\usage{
filter_index(.data, ...)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{Formulas that specify start and end periods (inclusive) or strings.
\itemize{
\item \code{~ end} or \code{. ~ end}: from the very beginning to a specified ending period.
\item \code{start ~ end}: from specified beginning to ending periods.
\item \code{start ~ .}: from a specified beginning to the very end of the data.
Supported index type: \code{POSIXct} (to seconds), \code{Date}, \code{yearweek}, \code{yearmonth}/\code{yearmon},
\code{yearquarter}/\code{yearqtr}, \code{hms}/\code{difftime} & \code{numeric}.
}}
}
\description{
This shorthand respects time zone and encourages compact expressions.
}
\examples{
# from the starting time to the end of Feb, 2015
pedestrian \%>\%
  filter_index(~ "2015-02")

# entire Feb 2015, & from the beginning of Aug 2016 to the end
pedestrian \%>\%
  filter_index("2015-02", "2016-08" ~ .)

# multiple time windows
pedestrian \%>\%
  filter_index(~ "2015-02", "2015-08" ~ "2015-09", "2015-12" ~ "2016-02")

# entire 2015
pedestrian \%>\%
  filter_index(~ "2015")

# specific
pedestrian \%>\% 
  filter_index("2015-03-23" ~ "2015-10")
pedestrian \%>\% 
  filter_index("2015-03-23" ~ "2015-10-31")
pedestrian \%>\% 
  filter_index("2015-03-23 10" ~ "2015-10-31 12")
}
\seealso{
\link{time_in} for a vector of time index
}
