% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{count_gaps}
\alias{count_gaps}
\alias{count_gaps.tbl_ts}
\title{Count implicit gaps}
\usage{
count_gaps(.data, ...)

\method{count_gaps}{tbl_ts}(.data, .full = FALSE, ...)
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{...}{Other arguments passed on to individual methods.}

\item{.full}{\code{FALSE} to find gaps for each group within its own period. \code{TRUE}
to find gaps over the entire time span of the data.}
}
\value{
A tibble contains:
\itemize{
\item the "key" of the \code{tbl_ts}
\item ".from": the starting time point of the gap
\item ".to": the ending time point of the gap
\item ".n": the implicit missing observations during the time period
}
}
\description{
Count implicit gaps
}
\examples{
ped_gaps <- pedestrian \%>\% 
  count_gaps(.full = TRUE)
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  stop("Please install the ggplot2 package to run these following examples.")
}
library(ggplot2)
ggplot(ped_gaps, aes(x = Sensor, colour = Sensor)) +
  geom_linerange(aes(ymin = .from, ymax = .to)) +
  geom_point(aes(y = .from)) +
  geom_point(aes(y = .to)) +
  coord_flip() +
  theme(legend.position = "bottom")
}
\seealso{
Other implicit gaps handling: \code{\link{fill_gaps}},
  \code{\link{has_gaps}}
}
\concept{implicit gaps handling}
